------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                 A D A . T E X T _ I O . P I C T U R E S                  --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.7 $                              --
--                                                                          --
-- This specification is adapted from the Ada Reference Manual for use with --
-- GNAT.  In accordance with the copyright of that document, you can freely --
-- copy and modify this specification,  provided that if you redistribute a --
-- modified version,  any changes that you have made are clearly indicated. --
--                                                                          --
------------------------------------------------------------------------------

package Ada.Text_IO.Pictures is

   type Picture is private;

   function Valid (Item : in String) return Boolean;

   function To_Picture (Item : in String) return Picture;

   function To_String (Item : in Picture) return String;

   Max_Picture_Length : constant := 30;

   Picture_Error : exception;

   --  Localization features:

   Max_Currency_Length : constant := 10;

   subtype Currency_Length_Range is
     Integer range 1 .. Max_Currency_Length;

   type Locale (Length : Currency_Length_Range := 1) is record
      Currency    : String (1 .. Length) := "$";
      Fill        : Character            := '*';
      Separator   : Character            := ',';
      Radix_Mark  : Character            := '.';
   end record;

   generic
      type Num is delta <> digits <>;

   package Edited_Output is

      Default_Locale  : Locale;

      function Length (Pic     : in Picture;
                       Symbols : in Locale := Default_Locale)
        return Natural;

      function Image (Item    : in Num;
                      Pic     : in Picture;
                      Symbols : in Locale  := Default_Locale)
        return String;

      procedure Put (File    : in File_Type;
                     Item    : in Num;
                     Pic     : in Picture;
                     Symbols : in Locale  := Default_Locale);

      procedure Put (Item    : in Num;
                     Pic     : in Picture;
                     Symbols : in Locale  := Default_Locale);

      procedure Put (To      : out String;
                     Item    : in Num;
                     Pic     : in Picture;
                     Symbols : in Locale  := Default_Locale);

   end Edited_Output;

private

   type Picture is record
      Length : Natural;
      Data   : String (1 .. 30);
   end record;

end Ada.Text_IO.Pictures;
