
#include <unistd.h>
#include <limits.h>
#include <time.h>
#include <errno.h>
#include <linux/param.h>

#define PAGESIZE 4096
#define LOGNAME_MAX PATH_MAX

long sysconf(int name)
{
  switch(name)
    {
    case _SC_ARG_MAX:
      return ARG_MAX;
    case _SC_CHILD_MAX:
      return CHILD_MAX;
    case _SC_CLK_TCK:
      return CLK_TCK;
    case _SC_NGROUPS_MAX:
      return NGROUPS;
    case _SC_OPEN_MAX:
      return OPEN_MAX;
    case _SC_PASS_MAX:
      return PASS_MAX;
    case _SC_PAGESIZE:
      return PAGESIZE;
    case _SC_JOB_CONTROL:
      return _POSIX_JOB_CONTROL;
    case _SC_VERSION:
    case _SC_XOPEN_VERSION:
      return _POSIX_VERSION;
    case _SC_LOGNAME_MAX:
      return LOGNAME_MAX;
    default:
      errno = EINVAL;
      return -1;
    }
}
