#include <stdio.h>
#include <trace.h>

/***************************************************************************
 *
 * Function:     getw
 *
 * Description:
 *    This is yet another non-portable routine to read a single word from
 *    the input. The problem is that a "word" is not defined in size. However,
 *    this is a required routine.
 *
 *    For iBCS, this is always 4 bytes.
 *
 * Entry:
 *    stream   - Pointer to the input stream
 *
 * Returns:
 *    The input word or -1 to indicate a possible error condition.
 *
 *    The word is always written in little-endian format.
 */

#ifdef ELF_LIBRARY
#define getw _getw
#endif

int getw (FILE *stream)
    {
    int nIndex;
    int nChar;
    int nWord = 0;
    int uchBuffer [sizeof (int)];
    FUNC_ENTRY ("getw");
/*
 *  Fetch the value in little endian format only.
 */
    for (nIndex = 1; nIndex <= sizeof (int); ++nIndex)
        {
	nChar = getc (stream);
	if (nChar == EOF)
	    {
	    nWord = EOF;
	    break;
	    }
	uchBuffer [sizeof (int) - nIndex] = (unsigned char) nChar;
        }
/*
 *  Convert the input buffer to the proper value
 */
    if (nWord == 0)
        {
	for (nIndex = 0; nIndex < sizeof (int); ++nIndex)
	    {
	    nWord <<= 8;
	    nWord |= (int) (unsigned int) uchBuffer [nIndex];
	    }
        }
/*
 *  Return the result.
 */
    FUNC_EXIT ("getw");
    return (nWord);
    }


#ifdef ELF_LIBRARY
__asm__(".weak getw; getw = _getw");
#endif
