#include <stdio.h>
#include "file2.h"
#include "internal.h"
#include <stdlib.h>

#include <trace.h>
/************************************************************************
 *
 * Function:    _freebuf
 *
 * Description:
 *    discard all buffer information for the indicated file.
 *
 * Input:       stream - a pointer to the file to be released
 *
 * Output:      none.
 */

void _freebuf (FILE *stream)
    {
    FUNC_ENTRY ("_freebuf");

    if (inuse(stream) && mbuf(stream))
        {
        free(stream->_base);
        stream->_flag &= ~_IOFREEBF;
        stream->_base  =
        stream->_ptr   = NULL;
        stream->_cnt   = 0;
        }
    FUNC_EXIT ("_freebuf");
    }
