#include <sys/stat.h>
#include <stdlib.h>
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>

struct dirent *_readdir(DIR * dir)
{
  int result;
  struct dirent * dent;

  if (!dir) {
    errno = EBADF;
    return NULL; 
  }

  if (dir->dd_size > dir->dd_loc) {
    dent = (struct dirent *) &dir->dd_buf [(dir->dd_loc)];
    dir->dd_loc += dent->d_reclen;
  };

  if (dir->dd_size <= dir->dd_loc) {
    result = _getdents(dir->dd_fd, dir->dd_buf, DIRBUF);
    
    if(result <= 0) return NULL;
    
    dir->dd_size = result;
    dir->dd_loc = 0;
  } 

  return (struct dirent *) &(dir->dd_buf [(dir->dd_loc)]);
}



#ifdef ELF_LIBRARY
__asm__(".weak readdir; readdir = _readdir");
#endif
