#include <stdio.h>
#include <strings.h>

#include "linuxelf.h"
#include "abi.h"

struct Elf32_Sym * libc;
struct Elf32_Sym * libnsl;
struct Elf32_Sym * libsocket;

FILE * genfile[2] = {NULL, NULL};

void generate(char * name, int flags, struct symbol * sp)
{
  int libindex;
  switch(sp->libname)
    {
    case LIBSYS:
    case LIBC:
      libindex = 0;
      break;
    case LIBNSL:
      libindex = 1;
      break;
    }

  if (!genfile[libindex]) {
    switch(libindex)
      {
      case 0:
	genfile[libindex] = fopen("generate-libc.c","w");
	break;
      case 1:
	genfile[libindex] = fopen("generate-nsl.c","w");
	break;
      }
    if(!genfile[libindex]) exit(1);
    /*
     * This is wrong, but if we generate stubs for stdio functions, we get
     * prototype errors.
     */
    fprintf(genfile[libindex], "/* THIS FILE IS MACHINE GENERATED - DO NOT EDIT */\n");    
    fprintf(genfile[libindex], "typedef struct gen_iobuf\n\
    {\n\
    int            _cnt;\n\
    unsigned char *_ptr;\n\
    unsigned char *_base;\n\
    unsigned char  _flag;\n\
    unsigned char  _file;\n\
    } FILE;\n\
    \n\
extern   FILE   _iob[60];\n");

  }

  if(sp->flags & SYM_FUNCTION)
    {
      if(flags == STB_GLOBAL)
	{
	  fprintf(genfile[libindex], "void %s(void){\n", name);
	  fprintf(genfile[libindex], "  fprintf((&_iob[2]),\"ABI+ Error - function %%s not defined\\n\", \"%s\");\n", name);
	  fprintf(genfile[libindex],"  _exit(0);\n}\n", name);
	}
      if(flags == STB_WEAK)
	fprintf(genfile[libindex],"__asm(\".weak %s; %s=_%s\");\n", name,
		name, name);
    }

  if(sp->flags & SYM_DATA)
    {
      fprintf(genfile[libindex], "char %s[%d];\n", name, sp->size);
    }
  
  fprintf(genfile[libindex], "\n");
}

findsym(struct symbol * sp, struct Elf32_Sym * lib)
{
  char * synonym;
  int found_name = 0;
  unsigned int symbol_addr, synonym_addr;
  unsigned int symbol_size, synonym_size;
  int found_syn = 0;
  int expected_type;

  if(sp->flags & SYM_FUNCTION)    expected_type = STT_FUNC;
  else if(sp->flags & SYM_DATA)    expected_type = STT_OBJECT;
  else expected_type = STT_NOTYPE;

  if(sp->flags & SYM_SYNONYM)
    {
      synonym = (char *) malloc(strlen(sp->name) + 2);
      strcpy(synonym, "_");
      strcat(synonym, sp->name);
    }
  else
    {
      synonym = NULL;
      found_syn = 1;
    }

  /*
   * Now try and locate the function.
   */


  while(lib->st_name != 0)
    {
      if(strcmp((char *) lib->st_name, sp->name) == 0)
	{
	  found_name++;
	  symbol_addr = lib->st_value;
	  symbol_size = lib->st_size;
	  if(synonym)
	    {
	      if (ELF32_ST_BIND(lib->st_info) != STB_WEAK)
		fprintf(stderr, "Symbol has wrong scope (%s)\n", sp->name);
	    }
	  else
	    {
	      if (ELF32_ST_BIND(lib->st_info) != STB_GLOBAL)
		fprintf(stderr, "Symbol has wrong scope (%s)\n", sp->name);
	    }
	  if (ELF32_ST_TYPE(lib->st_info) != expected_type)
	    {
	      fprintf(stderr,"Symbol %s has an incorrect type\n", sp->name);
	    }
	}
      if(synonym && strcmp((char *) lib->st_name, synonym) == 0)
	{
	  found_syn++;
	  if (ELF32_ST_BIND(lib->st_info) != STB_GLOBAL)
	    fprintf(stderr, "Symbol has wrong scope (%s)\n", sp->name);
	  synonym_addr = lib->st_value;
	  synonym_size = lib->st_size;
	}
      lib++;
    }

  if(synonym && found_syn && found_name)
    {
      if(synonym_addr != symbol_addr)
	fprintf(stderr, "Symbol %s has an incorrect alias\n", sp->name);
    }

  /*
   * Verify that the size of the variables is correct.
   */
  if(sp->flags & SYM_DATA)
    {
      if(found_name && symbol_size != sp->size)
	fprintf(stderr,"Symbol %s has incorrect size (%d %d)\n", sp->name,
		symbol_size, sp->size);
      if(found_syn && synonym && synonym_size != sp->size)
	fprintf(stderr,"Symbol %s has incorrect size (%d %d)\n", sp->name,
		synonym_size, sp->size);
    }

  if(!found_syn)
    {
      if(sp->flags & SYM_REQUIRED)
	fprintf(stderr,"Missing function %s\n", synonym);
      if(sp->flags & SYM_OPTIONAL)
	generate(synonym, STB_GLOBAL, sp);
    }
  if(!found_name)
    {
      if(sp->flags & SYM_REQUIRED)
	fprintf(stderr,"Missing function %s\n", sp->name);
      if(!found_syn || synonym == NULL)
	{
	  if(sp->flags & SYM_OPTIONAL)
	    generate(sp->name, (synonym != NULL ? STB_WEAK : STB_GLOBAL), sp);
	}
      else
	fprintf(stderr,"Unable to generate weak synonym for %s\n", sp->name);
    }

  return (found_name && found_syn);

}


extern struct Elf32_Sym * readsyms(char *);
extern struct symbol abi_plus[];

main()
{
  struct symbol * sp;

  libc      = readsyms("pre-libc.so.1");
  libnsl    = readsyms("pre-libnsl.so");
  libsocket = readsyms("pre-libsocket.so");

  /*
   * Now walk the list of symbols that we should have, and make sure we
   * have them.
   */
  for(sp = &abi_plus[0]; sp->name; sp++)
    {
      switch(sp->libname)
	{
	case LIBSYS:
	case LIBC:
	  findsym(sp, libc);
	  break;
	case LIBNSL:
	  findsym(sp, libnsl);
	  break;
	default:
	  break;
	}
    }

  return 0;
}
