#!/bin/sh
# @(#) $Id: mkaliases.sh,v 1.4 1992/07/11 11:40:01 tron Exp $
#
#    Copyright (C) 1987, 1988 Ronald S. Karr and Landon Curt Noll
#    Copyright (C) 1992  Ronald S. Karr
# 
# See the file COPYING, distributed with smail, for restriction
# and warranty information.

# mkaliases - create an aliases database for a smail aliasfile director
#
# Usage: mkaliases
#
# Rebuilds the aliasfile specified in X_EDITME_X.
# Different types for the aliasfile are rebuilt in different ways.
# In the case of lsearch, verification is performed on the file,
# but no other changes are made.

PATH='X_UTIL_PATH_X:X_SECURE_PATH_X'; export PATH
ALIASES_FILE='X_PATH_ALIASES_FILE_X'
ALIASES_TYPE='X_ALIASES_TYPE_X'

case "$ALIASES_TYPE" in

bsearch )
	ALIASES_DIR="`echo "$ALIASES_FILE" | sed 's,/[^/]*$,,'`"
	case "$ALIASES_FILE" in

	*.sort)	TEXT_FILE="`basename "$ALIASES_FILE" .sort`" ;;
	* )	TEXT_FILE="`basename "$ALIASES_FILE"`".txt ;;

	esac
	if mkline "$ALIASES_DIR/$TEXT_FILE" |
		wc -lc |
		awk '{ print $1 " entries, " $2 " bytes total" }'
	then :; else exit 1; fi
	mkline "$ALIASES_DIR/$TEXT_FILE" |
		mksort -f > "$ALIASES_DIR/.$TEXT_FILE"
	mv -f "$ALIASES_DIR/.$TEXT_FILE" "$ALIASES_FILE"
	;;

dbm )	mkline "$ALIASES_FILE" | mkdbm -f -v -o "$ALIASES_FILE" ;;

lsearch ) mkline "$ALIASES_FILE" | wc -lc |
		awk '{ print $1 " entries, " $2 " bytes total" }'
	;;

yp | aliasyp )
	echo "$0: aliases database maintained over YP";;

* )	echo "$0: unknown file type, $ALIASES_TYPE, for $ALIASES_FILE" ;;

esac

exit 0
