#ifndef _LINUX_APM_H
#define _LINUX_APM_H

/*
 * Include file for the interface to an APM BIOS
 * by Stephen Rothwell
 *    Stephen.Rothwell@pd.necisa.oz.au
 *
 * $Id: apm_bios.h,v 0.5 1994/12/19 04:56:39 sfr Exp $
 */

typedef unsigned short	apm_event_t;

#ifdef __KERNEL__

#include <linux/tasks.h>	/* for NR_TASKS */
#include <linux/sched.h>	/* for _TSS */

#define APM_CS		_TSS(NR_TASKS)
#define APM_CS_16	(APM_CS + 8)
#define APM_DS		(APM_CS_16 + 8)

struct apm_bios_info {
	unsigned short	version;
	unsigned short	cseg;
	unsigned long	offset;
	unsigned short	cseg_16;
	unsigned short	dseg;
	unsigned short	flags;
	unsigned short	cseg_len;
	unsigned short	dseg_len;
};

#define APM_16_BIT_SUPPORT	0x0001
#define APM_32_BIT_SUPPORT	0x0002
#define APM_IDLE_SLOWS_CLOCK	0x0004
#define APM_BIOS_DISABLED      	0x0008

/*
 * in init/main.c
 */
extern struct apm_bios_info	apm_bios_info;

extern long		apm_bios_init(long);

extern int		apm_register_callback(int (*callback)(apm_event_t));
extern void		apm_unregister_callback(int (*callback)(apm_event_t));

#endif	/* __KERNEL__ */

/*
 * Power states
 */
#define APM_STATE_READY		0x0000
#define APM_STATE_STANDBY	0x0001
#define APM_STATE_SUSPEND	0x0002
#define APM_STATE_OFF		0x0003
#define APM_STATE_BUSY		0x0004
#define APM_STATE_REJECT	0x0005

/*
 * Events
 */
#define APM_SYS_STANDBY		0x0001
#define APM_SYS_SUSPEND		0x0002
#define APM_NORMAL_RESUME	0x0003
#define APM_CRITICAL_RESUME	0x0004
#define APM_LOW_BATTERY		0x0005
#define APM_POWER_STATUS_CHANGE	0x0006
#define APM_UPDATE_TIME		0x0007
#define APM_CRITICAL_SUSPEND	0x0008
#define APM_USER_STANDBY	0x0009
#define APM_USER_SUSPEND	0x000a
#define APM_STANDBY_RESUME	0x000b

/*
 * Error codes
 */
#define APM_SUCCESS		0x00
#define APM_DISABLED		0x01
#define APM_CONNECT		0x02
#define APM_NOT_CONNECT		0x03
#define APM_BAD_DEVICE		0x09
#define APM_BAD_PARAM		0x0a
#define APM_BAD_STATE		0x60
#define APM_NO_EVENTS		0x80
#define APM_NOT_PRESENT		0x86

/* ioctl operations */
#include <linux/ioctl.h>

#define APM_IOC_STANDBY		_IO('A', 1)
#define APM_IOC_SUSPEND		_IO('A', 2)

#endif	/* LINUX_APM_H */
