/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 * rgb.c - interface with rgb format.
 *
 * Author:      Raul Rivero
 *              Mathematics Dept.
 *              University of Oviedo
 * Date:        Sun Feb 2 1992
 * Copyright (c) 1992, Raul Rivero
 *
 */

#include <lug.h>
#include <lugfnts.h>

extern int LUGverbose;

read_rgb_i_file( name, bitmap )
char *name;
bitmap_hdr *bitmap;
{
  int xsize, ysize;

  fprintf( stderr, "Enter image size ( x y ): " );
  scanf( "%d %d", &xsize, &ysize);

  /* Read the bitmap */
  read_rgb_file( name, bitmap, xsize, ysize);
}

read_rgb_file( name, bitmap, xsize, ysize )
char *name;
bitmap_hdr *bitmap;
int xsize, ysize;
{
  FILE *handle;

  /* Open the file descriptor */
  if ( name != NULL )
    handle = Fopen( name, "rb" );
  else handle = stdin;

  /* Read the bitmap */
  read_rgb( handle, bitmap, xsize, ysize );
  rm_compress();

  /* Close the file */
  Fclose( handle );
}

read_rgb( handle, bitmap, xsize, ysize )
int xsize, ysize;
FILE *handle;
bitmap_hdr *bitmap;
{
  register int i, j;
  long totalsize;
  byte *buffer, *ptr;
  byte *r, *g, *b;

  /* Fill the new header */
  bitmap->magic = LUGUSED;
  bitmap->xsize = xsize;
  bitmap->ysize = ysize;
  totalsize = (long)xsize * (long)ysize;
  bitmap->depth = 24;
  bitmap->colors = ( 1 << bitmap->depth );

  /* Allocate buffers */
  r = bitmap->r = (byte *) Malloc( totalsize );
  g = bitmap->g = (byte *) Malloc( totalsize );
  b = bitmap->b = (byte *) Malloc( totalsize );
  ptr = buffer = (byte *) Malloc( 3 * xsize );

  /* Read the bitmap info ( each line ) */
  for ( i = 0; i < ysize; i++ ) {
    if ( fread( buffer, xsize, 3, handle ) != 3 ) {
      VPRINTF( stderr, "Error reading line %d", i);
      return 1;
    }
    /*
     * The format of the information is RGBRGB...RGB, we
     * need split this ...
     */
    for ( j = 0, ptr = buffer; j < xsize; j++ ) {
      *r++ = *ptr++;
      *g++ = *ptr++;
      *b++ = *ptr++;
    }
  }

  /* Free momory */
  free( buffer );

  /* No errors */
  return  0;
}

write_rgb_file( name, image )
char *name;
bitmap_hdr *image;
{
  FILE *handle;

  /* Open the file descriptor */
  if ( name != NULL )
    handle = Fopen( name, "wb" );
  else handle = stdout;

  /* Write the bitmap */
  write_rgb( handle, image );

  /* Close the file */
  Fclose( handle );

}

write_rgb( handle, bitmap )
FILE *handle;
bitmap_hdr *bitmap;
{
  register int i, j;
  byte *buffer;
  byte *ptr;
  byte *r, *g, *b;

  if ( bitmap->magic != LUGUSED )
    error( 19 );

  if ( bitmap->depth < 24 ) {
    write8bitmap( handle, bitmap );
    return 1;
  }

  /* Set pointers */
  buffer = (byte *) Malloc( 3 * bitmap->xsize );
  r = bitmap->r;
  g = bitmap->g;
  b = bitmap->b;

  for ( i = 0; i < bitmap->ysize; i++ ) {
    /*
     * The format of the information is RGBRGB...RGB so we
     * need convert our splitted R-G-B ...
     */
    for ( j = 0, ptr = buffer; j < bitmap->xsize; j++ ) {
      *ptr++ = *r++;
      *ptr++ = *g++;
      *ptr++ = *b++;
    }
    Fwrite( buffer, bitmap->xsize, 3, handle );
  }

  /* Free memory */
  free( buffer );

  return 0;

}
