/*
 *  nodeparm.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ckfncplc.h"
struct ScaledType;
class Compound ;
class TextFragmentList ;
class ArraySize ;
class MofStream ;
class OutTokens ;

struct NodeParameter {
	struct ScaledType * Type ;
	const char * ClassType ;
	const char * Name ;
	Compound * Lower ;
	Compound * Default ;
	Compound * Upper ;
	TextFragmentList * HelpLine ;
	TextFragmentList * FullDescription ;
	ArraySize * Size ;
	TextFragmentList * LegalCheck ;
	int SubroutineDefault ;
	int FirstDefault ;

	void Init();

	NodeParameter(ScaledType * typ, const char * name,  Compound * low,
		Compound * def, Compound * up, TextFragmentList * menu,
		TextFragmentList * full, ArraySize * s = 0) ;
 	NodeParameter(const char * typ, const char * name, const char * def,
		TextFragmentList * menu, TextFragmentList * full) ;
	NodeParameter(ScaledType *  typ, const char * Name);
	NodeParameter(const char * ClassName, const char * Name);
	NodeParameter(const char * Name);
	~NodeParameter();
	void EmitDefaultValue(MofStream& Out) ;
	int IsChangeable();
	void EmitSetNodeParameterValue(MofStream& Out, const char *Name,
		int& Index) ;
	void EmitParamCheckFunc(MofStream& Out, CheckFuncPlace Place) ;
	void ParamOut(MofStream& Out, const char * BaseName) ;
	void ParamArrayEltOut(MofStream& Out, const char * NodeName) ;
	void CompleteArrayEltForArray(MofStream& Out, const char * NodeName) ;
	void DefaultArrayOut(MofStream& Out, MofStream& Hout,
		const char * DefAryName) ;
	void EmitInteractiveGetValue(MofStream& Out, const char * Prefix=0) ;
	void EmitInteractiveMemberParameter(MofStream& Out, const char * Pre) ;
	void EmitMemberEntry(MofStream& Out, const char * NodeName,
		const char * Pre=0) ;
	void EmitInteractiveGetValueKernel(MofStream& Out, const char * Pre) ;
	void EmitGetParameter(MofStream& Out) ;
	void EmitCallGetParameter(MofStream& Out) ;
	void EmitBaseGetParameter(MofStream& Out, const char * Where) ;
	void SetSubroutineDefault() {SubroutineDefault = 1; }
	void EmitCheckFunctionDefiniton(MofStream& Out, const char * NodeName);
	const char * MakeLegalCheckName(const char * NodeName) ;
	int IsFirstDefault() {return FirstDefault;}
	void EmitFirstDefault(MofStream& Out) ;
	void OutTeX(OutTokens& Out);
	int PositionOneParameter() const ;
} ;

class NodeParameterList: public SingleList {
public:
	ErrCode Insert(NodeParameter *nt) {return SingleList::Insert(nt);}
	ErrCode Append(NodeParameter *nt) {return SingleList::Append(nt);}
	NodeParameter * Get()   {return (NodeParameter *) SingleList::Get();}
	NodeParameter * Pop() {return (NodeParameter *) SingleList::Pop();}
	NodeParameter * GetNFromTop(int N) ;
	NodeParameter * GetNthEntry(int N) ;
	NodeParameterList(){}
	~NodeParameterList();
	int Size(){return SingleList::Size();}
	int AnyChangeable();
	void CheckAtMostOneFirstDefault();
	void OutTeX(OutTokens& Out);
	void BriefOutTeX(OutTokens& Out);
} ;

class NodeParameterListIterator: public SingleListIterator {
public:
	NodeParameterListIterator(NodeParameterList& df):
		SingleListIterator((SingleList&) df){}
	NodeParameter * operator()()
		{return (NodeParameter *) Next();}
};

