/*
 *  menunm.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <iostream.h>
#include <fstream.h>
#include "fileios.h"
#include <string.h>
#include "menunm.h"

void EmitNodeMenuInstancesName(MofStream * Stream, const char * NodeName)
{
	*Stream << NodeName << "InstancesMenu" ;
}

void EmitNodeMenuName(MofStream * Stream, const char * NodeName)
{
	*Stream << NodeName << "NodeOptMenu" ;
}

void EmitNodeMenuMemberName(MofStream * Stream, const char * NodeName)
{
	*Stream << NodeMenuMemberName(NodeName);
}

const char * NodeMenuMemberName(const char * NodeName)
{
	static int Size = 0 ;
	static char * Buf = 0;
	static const char * Suffix = "NodeMemberMenu" ;
	int Length = strlen(NodeName) + strlen(Suffix)+1;
	if (Size < Length) {
		delete Buf ;
		Buf = new char [Length] ;
		Size = Length ;
	}
	strcpy (Buf,NodeName);
	strcat (Buf,Suffix);
	return Buf ;
}



