/*
 *  menustr.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <iostream.h>
#include <string.h>
#include <libc.h>
#include "menustr.h"
#include "domenus.h"
#include "linlist.h"
#include "debug.h"
#include "y.tab.h"
#include "outtok.h"
#include "texmenu.h"
#include "texutil.h"
#include "mkstr.h"
#include "parammen.h"
#include "texspec.h"
#include "classrel.h"


MenuDefList TheMenuDefs ;
MenuDefList TheOrphans ;

MainEntryList MainEntrys ;

static const char * MMSNodLib = "\\cite{MMS:NodLib}" ;



class TeXPrintDesc: public OutTokens {
	int SectionLevel ;
	int SectionDepth ;
	const int MaxLevel ;
public:

	TeXPrintDesc& Push(int MainFlag = 0) ;
	TeXPrintDesc& Pop(int MainFlag = 0);

	TeXPrintDesc(ostream& out, int sec_lev);

	void OutIndexedSection(const MenuDef * menu) ;
	void BlankLine() {FlushLine(); NewLine();}
};
	
TeXPrintDesc::TeXPrintDesc(ostream& out, int sec_lev):
	OutTokens(&out,0,""," ","",80,1000000),
	MaxLevel(MaxTeXSectionDepth() -1),
	SectionLevel(sec_lev),
	SectionDepth(sec_lev)
{
}

TeXPrintDesc& TeXPrintDesc::Push(int MainFlag)
{
	if (MainFlag) return *this ;
	SectionDepth++ ;
	if (SectionLevel++ < MaxLevel) return *this ;
	SectionLevel = MaxLevel ;
	return *this ;
}
	
TeXPrintDesc& TeXPrintDesc::Pop(int MainFlag)
{
	if (MainFlag) return *this ;
	if (--SectionDepth < 1) {
		cerr << "MenuDef::Pop level < 1\n" ;
		exit(1);
	}
	SectionLevel = SectionDepth ;
	if (SectionLevel > MaxLevel) SectionLevel = MaxLevel ;
	return *this ;
}

void TeXPrintDesc::OutIndexedSection(const MenuDef * menu)
{
	const char * title = menu->Title;

	NextConcatToken("\\");
	NextConcatToken(GetTeXSectionName(SectionLevel));
	NextConcatToken("{");
	NextConcatToken(TeXString(title));
	NextOutToken("}");
	ConditionalTeXIndex(*this,title);
	FlushLine();
 	if (!menu->IsTemplate()) if (!menu->IsOrphan())
		ConditionalTeXIndex(*this, menu->GetMenuCommand());
	FlushLine();
/*
 *	NextConcatToken("\\label{");
 *	NextConcatToken(menu->GetRef());
 *	NextOutToken("}");
 *	FlushLine();
 */

}

MenuDef::MenuDef(const char * name, InitValue * init, const char * title,
	MenuItemList * items, MenuType type):
	Name(name),
	Init(init),
	Title(title),
	Items(items),
	Type(type),
	MenuObject(0),
	TheClassRelation(TheClassRelations.GetCurrentClass())
{
/*
 *	if (TheClassRelation) cerr << "Class Name for `" << GetName() <<
 *		"' is `" << TheClassRelation->GetDerived() << "'.\n" ;
 */
	TheClassRelations.FoundMenuDef(*this);
}

void MenuDef::MainMenuHelp(TeXPrintDesc& Out) const
{
	Out.BlankLine();
	Out.NextFillOut("This is the main \\Dpp{} menu.");
	Out.NextFillOut("All other menus and commands are reachable from");
	Out.NextFillOut("this menu.");
	Out.BlankLine();
}

void MenuDef::OrphanExecOut(OutTokens& Out) const
{
	Out.NextFillOut("The following member functions can be selected");
	Out.NextFillOut("for execution in the clases derived from them.");
	Out.NextFillOut("See Section~\\PageRef{Sec:ClassStruc} for a");
	Out.NextFillOut("description of the \\Dpp{} class structure.");
}

void MenuDef::OrphanOut(OutTokens& Out) const
{
	Out.NextFillOut("The following member functions can be selected");
	Out.NextFillOut("to be described in the clases derived from them.");
	Out.NextFillOut("See Section~\\PageRef{Sec:ClassStruc} for a");
	Out.NextFillOut("description of the \\Dpp{} class structure.");
}


void MenuDef::TeXSectionHeader(TeXPrintDesc& Out) const
{
	Out.NextConcatToken("\\label{");
	Out.NextConcatToken(GetObject()->GetRef());
	Out.NextOutToken("}");
	Out.FlushLine();

	const MenuItem * Parent = GetParentItem();
	if (!Parent) {
		if (IsMemberFunctionExecSelector()) OrphanExecOut(Out);
		else if (IsMemberFunctionSelector()) OrphanOut(Out);
		else MainMenuHelp(Out);
		return ;
	}
	const HelpText * TheHelpText = Parent->GetMenuHelp();
	if (!TheHelpText) return ;
	Out.BlankLine();
	TheHelpText->TeXOut(Out);
	Out.BlankLine();
}

void MenuDef::PrintChildrenSections(TeXPrintDesc& Out) const
{
	// cerr << "PrintChildren for `" << Name << "'\n" ;
	if (!Items) return ;
	MenuItemListIterator Next(*Items) ;
	const MenuItem * NextItem ;
	while (NextItem = Next()) NextItem->TeXPrintSection(Out);
}

void MenuDef::PrintChildren(TeXPrintDesc& Out) const
{
	if (!Items) return ;
	if (!Items->Size()) return ;

	Out.NextFillOut("The commands in this menu are:");
	Out.FlushLine();
	MenuItemListIterator Next(*Items) ;
	MenuItem * NextItem ;
	Out.NextOut("\\begin{itemize}");
	Out.FlushLine();
	while (NextItem = Next()) NextItem->TeXPrintInParentSection(Out);
	Out.FlushLine();
	Out.NextOut("\\end{itemize}");
	Out.FlushLine();
	{
		MenuItemListIterator Next(*Items) ;
		while (NextItem = Next()) NextItem->TeXPrintSection(Out);
	}
}

void MenuDef::TeXPrint(TeXPrintDesc& Out) const
{
/*
 *	cerr << "TeXPrint for `" << Name << "' IsOutput() = " << IsOutput()
 *		<< "\n" ;
 */
	if (IsOutput()) return ;
	if (!IsPrinted()) return ;
	int ForceNewLevel = TheTeXMenus->GetFixedLevel(Name)  ;
	Out.OutIndexedSection(this);
	if (ForceNewLevel != TeXMenus::NoFixedLevel) {	
		Out.FlushLine();
		Out.NextConcatToken("\\label{FrcLev:");
		Out.NextConcatToken(Name);
		Out.NextOutToken("}");
		Out.FlushLine();
	}
	if (TheTeXMenus->HeadPrintDynamicTree(Name)) {
		Out.FlushLine();
		Out.NextConcatToken("\\label{Sec:");
		Out.NextConcatToken(Name);
		Out.NextOutToken("}");
		Out.FlushLine();
	}
	TeXSectionHeader(Out);
	SetIsOutput();
	if (ForceNewLevel == TeXMenus::NoFixedLevel) {
		PrintChildren(Out.Push(IsMainMenu()));
		Out.Pop(IsMainMenu());
		return ;
	}
	
	TeXPrintDesc NewOut(*(Out.GetStream()),ForceNewLevel);
	PrintChildren(NewOut) ;
}

void MenuDef::TeXPicture(TeXPrintDesc& Out) const
{
	Out.NewLine();
	Out.NextOut("\\begin{center}");
	Out.FlushLine();
	Out.NextOut(Title);
	Out.FlushLine();
	Out.NextOut("\\end{center}");
	Out.FlushLine();
	Out.NewLine();
}

void MenuDef::OrphanSectionHead(TeXPrintDesc& Out) const
{
	Out.NextOut("\\section{Base class member functions}");
	Out.FlushLine();
	Out.NextOut("\\index{base class member functions}");
	Out.NewLine();
	Out.FlushLine();
	Out.NextFillOut("This section contains member functions of");
	Out.NextFillOut("\\Dppp{} base classes that are not used directly.");
	Out.NextFillOut("These member functions are shared by several derived");
	Out.NextFillOut("classes and are referenced from those classes.");
	Out.FlushLine();
	Out.NewLine();
	Out.Push();
}

void MenuDef::PrintAllOrphanedMenus(TeXPrintDesc& OutDesc) const
{
	const ObjectDescript ** TheMenus = TheTeXMenus->GetAllMenus();
	int FirstTime = 1 ;
	for (ObjectDescript ** Check = TheMenus; *Check; Check++) {
		const MenuDef * ToPrint = (*Check)->GetMenu();
		if (ToPrint->IsOutput()) continue ;
		const ClassRelation * ThisClass = ToPrint->GetClassRelation();
		if (!ThisClass) continue ;
		if (ThisClass->TheMemberFunctionTree ||
			ThisClass->TheMemberFunctionExecuteTree) {
			if (FirstTime) OrphanSectionHead(OutDesc);
			FirstTime = 0 ;
			ToPrint->TeXPrint(OutDesc);
		}
	}
}


void MenuDef::PrintAllTeXMenus(ostream& out) const
{
	// cerr << "MenuDef::PrintAllTeXMenus\n" ;
	TeXPrintDesc OutDesc(out,1);
	TeXPrint(OutDesc);
	PrintAllOrphanedMenus(OutDesc);
}

int MenuDef::IsThisMenu(const char * name) const
{
	return !strcmp(Name,name);
}

const char * MenuDef::GetRef() const
{
	const char * Return = 0 ;
	const ObjectDescript * Obj = GetObject();
	if (Obj) Return = Obj->GetRef();
	if (Return) return Return ;
	return "NULL_OBJECT";
}

int MenuDef::IsOutput() const
{
	return GetObject()->IsOutput();
}

void MenuDef::SetIsOutput() const
{
	ObjectDescript * ToSet = (ObjectDescript *) GetObject();
	// We violat constant rules here ONLY to set flag
	// indicating menus is already output
	if (ToSet) ToSet->SetIsOutput();
}

const MenuItem * MenuDef::GetThisItem(const char * Name) const
{
	if (!Items) return 0 ;
	return Items->FindItem(Name);
}

const MenuItem * MenuDef::GetParentItem() const
{
	const MenuDef * Parent = GetParent() ;
	if (!Parent) return 0 ;
	return Parent->GetThisItem(Name);
}

const MenuDef * MenuDef::GetParent() const
{
	if (GetObject()) return GetObject()->GetParent();
	return 0 ;
}

const char * MenuDef::GetMenuCommand() const
{
	const char * Return = "Main menu" ;
	const MenuItem * ParentItem = GetParentItem();
	// cerr << Name << " ParentItem = " << (char *) ParentItem << "\n" ;
	if (ParentItem) Return = ParentItem->GetCommand();
	return Return ;
}

int MenuDef::IsMainMenu() const
{
	return !strcmp(Name, TheTeXMenus->GetMainMenuName()) ;
}

void MenuDef::SetDoNotPrint()
{
	if (IsDoNotPrint()) return ; // avoid recursion
	((ObjectDescript *)GetObject())->SetDoNotPrint() ;
	if (!Items) return ;
	MenuItemListIterator Next (*Items) ;
	MenuItem * item ;
	while (item = Next()) item->SetChildrenDoNotPrint() ;
}

void MenuDef::SetChildrenPrintDynamic(int AvoidRecursion) const
{
	if (AvoidRecursion && GetObject()->IsPrintDynamic()) return ;
	// cerr << "Setting Dynamic Print for " << Name << "\n" ;
	((ObjectDescript *)GetObject())->SetPrintDynamic();
	if (!Items) return ;
	MenuItemListIterator Next (*Items) ;
	MenuItem * item ;
	while (item = Next()) item->SetChildrenPrintDynamic();
}

int MenuDef::IsPrintDynamic() const 
{
	if (GetObject()) return GetObject()->IsPrintDynamic();
	return 1; // Main menu
}

int MenuDef::IsDoNotPrint() const
{
	if (GetObject()) return GetObject()->IsDoNotPrint();
	return 1 ;
}

int MenuDef::IsPrinted() const 
{
	if (IsDoNotPrint()) return 0 ;
	if (!Type.IsMultiUse() && !IsDynamicMenu()) return 1;
	return IsPrintDynamic();
}

int MenuDef::IsTemplate() const
{
	if (!strcmp(Template,GetMenuCommand())) return 1 ;
	static const char * Translate = 0 ;
	if (!Translate) Translate=TeXString(Template);
	if (!strcmp(GetMenuCommand(),Translate)) return 1 ;
	for (const char * ck = GetMenuCommand(); *ck; ck++) if (*ck == '#')
	{
		cerr << "`" << GetMenuCommand()  << "' failed : `" <<
			Template << "' & `" << Translate << "'.\n" ;
		return 1 ;
	}
	return 0 ;
}

static int strcmptail(const char * Check, const char * Tail)
{
	int TailSize = strlen(Tail);
	int CheckSize = strlen(Check);
	if (Check < Tail) return 1 ;
	return strcmp(Tail,Check + CheckSize - TailSize);
}

int MenuDef::IsMemberFunctionExecSelector() const
{
	return !strcmptail(GetName(),"MemberExecute") ;
}

int MenuDef::IsMemberFunctionSelector() const
{
	return !strcmptail(GetName(),"MemberDescribe")  ;
}

int MenuItem::IsMemberFunctionExecSelector() const
{
	const char * Act = GetAction()->Name ;
	if (!strcmptail(Act,"MemberExecute")) return 1 ;
	if (strcmp(Act,"Orphan")) return 0 ;
	return !strcmp(GetCommand(),"exec");
}

int MenuItem::IsMemberFunctionSelector() const
{
	const char * Act = GetAction()->Name ;
	// cerr << "IsMemberF - " << Act << " " << GetCommand() ;
	int Return = !strcmptail(Act,"MemberDescribe")  ;
	if (!Return) if(!strcmp(Act,"Orphan"))
		Return = !strcmp(GetCommand(),"members");
	// cerr << " returning " << Return << "\n" ;
	return Return ;
}

void MenuItem::CheckForBaseClassReference(TeXPrintDesc& Out) const 
{
	if (IsMemberFunctionExecSelector()) OutputBaseMemberRefExec(Out);
	if (IsMemberFunctionSelector()) OutputBaseMemberRef(Out);
}

void MenuItem::OutputBaseMemberRefExec(TeXPrintDesc& Out) const
{
	if (TheClassRelation) TheClassRelation->TeXOutExecuteRef(Out);
}

void MenuItem::OutputBaseMemberRef(TeXPrintDesc& Out) const
{
	if (TheClassRelation) TheClassRelation->TeXOutDescribeRef(Out);
}

void MenuDef::OutRef(OutTokens& Out) const
{
	Out.NextConcatToken("Section~\\PageRef{");
	Out.NextConcatToken(GetRef());
	Out.NextOutToken("}");
}

const MenuItem * MenuItemList::FindMenu(const char * Name)
{
	const MenuItem * Item = FindItem(Name);
	if (Item) if (Item->IsMenu()) return Item ;
	// cerr << "MenuItemList::FindMenu(" << Name << ") returning 0.\n" ;
	return 0 ;
}

const MenuItem * MenuItemList::FindItem(const char * Name) 
{
	MenuItemListIterator Next(*this);
	const MenuItem * Item ;
	while (Item = Next()) {
		if (!strcmp(Name,Item->GetRefName())) return Item ;
	}
	return 0 ;
}

void MenuItemList::TeXPrint(TeXPrintDesc& Out)
{
}


const MenuDef * MenuDefList::FindParentMenu(const char * Name)
{
	// cerr << "Looking for parent of `" << Name << "'\n" ;
	MenuDefListIterator Next(*this) ;
	const MenuDef * NextMenu ;
	while (NextMenu = Next()) {
		// cerr << "Checking menu " << NextMenu->Name << "\n" ;
		if (NextMenu->Items)
			if (NextMenu->Items->FindMenu(Name)) return NextMenu ;
	}
	return 0 ; 
}

const MenuDef * MenuDefList::FindMenu(const char * Name)
{
	MenuDefListIterator Next(*this) ;
	const MenuDef * NextMenu ;
	while (NextMenu = Next()) {
		if (NextMenu->IsThisMenu(Name)) return NextMenu ;
	}
	return 0 ; 
}

void MenuDefList::TeXPrint(ostream& Out)
{
}

MenuItem::MenuItem(const char * cmd, ParameterizedAction * act, int typ,
	ParameterizedAction * init, int InitAct, const char * MenStr,
	const char * help_ref ,
	HelpText * help, const char * help_name):
	CommandObject(0),
	TheClassRelation(TheClassRelations.GetCurrentClass())
{
	Command = cmd ;
	Action = act  ;
	ActionType = typ;
	Init = init ;
	InitActionType = InitAct ;
	MenuString = MenStr;
	MenuHelpReference = help_ref;
	MenuHelp = help ;
	HelpFileName = help_name;
}

MenuItem::MenuItem(MenuItem& Item)
{
	Command = Concatenate(Item.GetCommand());
	Action = Item.GetAction();
	ActionType = Item.GetActionType();
	Init = Item.GetInit();
	InitActionType = Item.GetInitAction();
	MenuString = Concatenate(Item.GetMenuString());
	MenuHelp = Item.GetMenuHelp();
	// Dump("MenuItem::MenuItem(Item)");
	TheClassRelation = Item.GetClassRelation();
}

int MenuItem::IsMenu() const
{
	if (ActionType == NEW_MENU) return 1;
	if (ActionType == DYNAMIC_MENU) return 1;
	return 0 ;
}

const char * MenuItem::GetRef() const 
{
	const char * Return = 0 ;
	const ObjectDescript * Obj = GetObject();
	if (Obj) Return = Obj->GetRef();
	if (Return) return Return ;
	return "NULL_OBJECT";
}

int MenuItem::IsOutput() const
{
	return GetObject()->IsOutput();
}

void MenuItem::SetIsOutput() const
{
	ObjectDescript * ToSet = (ObjectDescript *) GetObject();
	// We violat constant rules here ONLY to set flag
	// indicating menus is already output
	if (ToSet) ToSet->SetIsOutput();
}

void MenuItem::TeXCommandType(TeXPrintDesc& Out) const 
{
}

int MenuItem::ChildIsEmpty() const 
{
	if (GetObject()) return GetObject()->GetChild() == 0 ;
	return 1 ;
}

void MenuItem::TeXPrintInParentSection(TeXPrintDesc& Out) const 
{
	if (IsMenu()) if (!IsChildMenuMentioned()) return ;
	Out.FlushLine();
	Out.BlankLine();
	const char * Ckmd = GetCommand() ;
	if (!strcmp(Ckmd,Template)) {
		Out.NextOut("\\item {\\it instance of this class}:");
	} else {
		Out.NextConcatToken("\\item {\\tt ");
		const char * Cmd = TeXString(Ckmd);
		Out.NextConcatToken(Cmd);
		Out.NextConcatToken("}\\index{");
		Out.NextConcatToken(Cmd);
		Out.NextOutToken("}:");
	}

	Out.NextOut(TeXString(GetMenuString()));
	Out.NextConcatCond('.');
	Out.NextOutToken();
	Out.FlushLine();

	// TeXCommandType(Out);
	if (!IsMenu()) {
		Out.NextFillOut("This menu option is a command.");
		Out.BlankLine();
		const HelpText * TheHelpText = GetMenuHelp();
		if (TheHelpText) TheHelpText->TeXOut(Out);
	} else {
		if (IsChildMenuPrintedInFull()) {
			Out.NextFillOut(
				"This menu option invokes the menu defined in");
			Out.NextConcatToken("Section~\\PageRef{");
			Out.NextConcatToken(GetChildRef()) ;
			Out.NextOutToken("}.");
		}  else if (!strcmp(Ckmd,"examples")) {
			Out.NextConcatToken("See Section~\\PageRef{");
			Out.NextConcatToken("Sec:Examples") ;
			Out.NextOutToken("}");
			Out.NextFillOut(
			"for a description of the examples menu and");
			Out.NextFillOut(
			"the basic set of examples. There may be additional examples available in your installation.");
		} else {
			Out.NextConcatToken("See Section~\\PageRef{");
			Out.NextConcatToken(
			TheTeXMenus->GetDynamicMenuTreeExamples());
			Out.NextOutToken("}");
			Out.NextFillOut(
			"for an example of the menu tree from this command");
			Out.NextConcatToken("and");
			Out.NextOutToken(MMSNodLib);
			Out.NextFillOut(
		"for a complete desciption of all options for this object");
			Out.NextConcatToken("{\\tt ");
			Out.NextConcatToken(GetCommand()) ;
			Out.NextOutToken("}.");
		}
		const MenuDef * child = GetChildMenu() ;
		CheckForBaseClassReference(Out);
	}
	Out.BlankLine();
}


const MenuDef * MenuItem::GetChildMenu() const 
{
	if (!IsMenu()) return 0 ;
	if (GetObject()) return GetObject()->GetChild();
	return 0 ;
}

void MenuItem::TeXPrintSection(TeXPrintDesc& Out) const 
{
	const MenuDef * Child = GetChildMenu() ;
/*
 *	cerr << "TeXPrintSection for `" << GetAction()->GetName() <<
 *		"' Child = " << (void *) Child << "\n" ;
 */
	if (Child) Child->TeXPrint(Out);
}

const char * MenuItem::GetRefName() const
{
	const char * Return = 0 ;
	if (GetAction()) Return = GetAction()->GetName();
	return Return ;
}

const char * TemplateName = "{\\tt select instance}" ;




const char * MenuItem::GetChildRef() const
{
	const char * Return ;
	if (GetObject()) if (Return = GetObject()->GetChildRef())
		return Return ;
	return "Child_Reference_Undefined" ;
}

const char * MenuItem::GetParentRef() const
{
	const char * Return ;
	if (GetObject()) if (Return = GetObject()->GetParentRef())
		return Return ;
	return "GET_PARENT_REF_NOT_DEFINED" ;
}
	
void MenuItem::TeXPrintCommand(OutTokens& Out) const 
{
	// for command index 
	if (IsMenu()) {
		if (!IsChildMenuPrintedInFull()) return ;
		const MenuDef * Parent = GetParent();
	}
	if (!IsChildMenuMentioned()) return ;

	// cerr << "TeXPrintCommand for " << GetCommand() << "\n" ;
	if (!strcmp(Template,GetCommand())) Out.NextOut (TemplateName) ;
	else {
		Out.NextConcatToken("{\\tt ");
		Out.NextConcatToken(TeXString(GetCommand()));
		Out.NextOutToken("}");
	}
	Out.NextConcat(":");
	Out.NextFillOut(TeXString(MenuString));
	Out.NextConcatCond('.');
	Out.NextConcatToken("Section~\\PageRef{");
	int RefPrinted = 0 ;
	if (IsMenu()) if (IsChildMenuPrintedInFull())  {
		Out.NextConcatToken(GetChildRef()) ;
		RefPrinted = 1 ;
	}
	if (!RefPrinted) Out.NextConcatToken(GetParentRef());
	Out.NextOutToken("}.");
	
	Out.FlushLine();
	Out.NewLine();
}

void MenuItem::SetChildrenDoNotPrint() const 
{
	((ObjectDescript *)GetObject())->SetDoNotPrint();
	if(!IsMenu()) return ;
	if (GetChildMenu()) ((MenuDef *) GetChildMenu())->SetDoNotPrint();
}

void MenuItem::SetChildrenPrintDynamic() const
{
	((ObjectDescript *)GetObject())->SetPrintDynamic();
	if(!IsMenu()) return ;
	if (GetChildMenu()) GetChildMenu()->SetChildrenPrintDynamic() ;
}

int MenuItem::IsChildMenuMentioned() const 
{
	if (!IsMenu()) return 0 ;
	const MenuDef * Parent = GetParent();
	if (Parent) return Parent->IsPrinted() ;
	return 1 ;
	
}


int MenuItem::IsChildMenuPrintedInFull() const 
{
	if (!IsMenu()) return 0 ;
	const MenuDef * Child = GetObject()->GetChild() ;
	if (Child) return Child->IsPrinted();
	return 0 ;
}

const MenuDef * MenuItem::GetParent() const
{
	if (GetObject()) return GetObject()->GetParent();
	return 0 ;
}



const char * MainEntryPair::ThisClass(const char * ClassName) const
{
	if (EmptyString(ClassName)) return 0 ;
	if (!strcmp(ClassName,AllMenus)) return MenuName ;
	return 0 ;
}

const char * MainEntryList::FindMainMenu(const char * MenuType)
{
	MainEntryListIterator Next(*this);
	MainEntryPair * Pair ;
	const char * Return = 0 ;
	while (Pair = Next()) if (Return = Pair->ThisClass(MenuType)) break ;
	return Return ;
}

void HelpText::TeXOut(OutTokens& Out) const 
{
	// cerr << "Text named `" << Name << "'\n" ;
	for (const char ** Ptr = TeXText; *Ptr; Ptr++) {
		// cerr << "Outputting:HelpText:`" << *Ptr << "'.\n" ;
		Out.NextFillOut(*Ptr);
	}
}


