/*
 *  menu_b.y from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
/* test
 *
 *
 */
%{
#include <stream.h>
#include <stdio.h>
#include "menuprsy.h"
%}
%union {
	int32 Int ;
	const char * Name ;
	union Value * Val ;
	struct TextFragmentList * Text ;
	struct Double * Dbl ;
	class MenuType * TheMenuType ;
	struct Compound * Tree ;
	} 
%token HELP_DEF DEF_HELP_FILE CONFLICT WAIT 
%token DEFINED_MENU DEFINED_ACTION MENU_ADDITION
%token ITEM_REF DEFAULT ITEM_HELP
%token MENU_LOCAL MENU_REMOTE MENU_REMOTE_OPTIONS
%token MAINS INIT
%token INCLUDE_LOCAL INCLUDE_REMOTE
%token MULTIPLE USE DYNAMIC HISTORY SELECT ADD_TO_MENU CONFLICT TEMPLATE
%token ORPHAN SHIFT_R SHIFT_L LEQ GEQ EQU NEQ AND OR 
%token OPERATOR
%token <Name> NAME STRING 
%token <Int> LOCAL REMOTE LOCAL_REMOTE REMOTE_OPTIONS
%token <Int> MENU NEW_MENU HELP_FILE DYNAMIC_MENU
%token <Text> TEXT 
%token <Int> INTEGER_VAL
%token <Dbl> DOUBLE_VAL USER_COPYRIGHT
%token <Name> EXPLICIT_STRING
%type <Int> StringChar Include
%type <Val> Name ConflictBody FirstConflict MenuBody MenuItem
%type <Val> String Command ActionType MenuTitle
%type <Val> WordString 
%type <Val> MenuInit Init
%type <Val> NameList MenuInitName InitName
%type <Val> PriorNameList
%type <Text> Help
%type <Name> HelpFile HelpRef Operator
%type <TheMenuType> Qualifier MenuId 
%type <Tree> Parameters ParameterList Parameter
%type <Int> PositiveInteger MenuStackReference
%type <Tree> Number Action
%%
Description : Prologue ObjectList 

	| ObjectList 

Prologue : User AlternativeMains

User : USER_COPYRIGHT {SetUserCopyright();} | {NoUserCopyright();}

AlternativeMains : MAINS '{' MainList '}'

MainList : MainEntry

	| MainList MainEntry

MainEntry : '[' Name '=' Name ']'		{MainEntry($2,$4);}

DefinedActionList : DEFINED_ACTION '{' NameList '}'

NameList : Name					{DefinedName($1);}

	| NameList ',' Name			{DefinedName($3);}

ObjectList : Object

	| ObjectList Object


Object : Menu 

	| HelpDef

	| HelpDefaultFile

	| DefinedActionList

	| ConflictList

	| IncludeEntry

	| InitEntry

	| ClassRelation

PriorNameList : Name				{$$=MakeNameList($1);}
	
	| PriorNameList ',' Name		{$$=NameListAppend($1,$3);}

IncludeEntry : '{' Include NAME '}'		{FoundInclude($2,$3);}

InitEntry : INIT  TEXT	Name '=' PriorNameList ';'
					 	{FoundInitCode($2,$3,$5);}

	| INIT TEXT Name ';'			{FoundInitCode($2,$3,0);}

ClassRelation : '{' NAME  NAME '}'		{FoundClassRelation($2,$3);} 

Include : INCLUDE_LOCAL				{$$=INCLUDE_LOCAL;}

	| INCLUDE_REMOTE			{$$=INCLUDE_REMOTE;}


HelpDef : HELP_DEF '{' NAME TEXT			{FoundHelpDef($3,$4);}

HelpDefaultFile : DEF_HELP_FILE EXPLICIT_STRING {FoundHelpDefaultFile($2);}

ConflictList : CONFLICT '{' Name '(' WordString ')' ConflictBody '}'
						{Conflict($3,$5,$7);}

ConflictBody : FirstConflict		{ $$ = FirstConflict($1);}

	| ConflictBody ',' WordString	{ $1->Strings->Append($3->Name);
						delete $3; }

FirstConflict : WordString ;

Menu : MenuId '{' Name MenuInit ':' MenuTitle MenuBody '}' {

						Menu(*$1,$3,$4,$6,$7);}

	| ADD_TO_MENU '{' Name MenuBody '}' 	{MenuAddition($3,$4);}

MenuId : Qualifier MENU

Qualifier : Qualifier DYNAMIC			{$1->SetDynamic(); $$=$1;}

	| Qualifier MULTIPLE USE		{$1->SetMultiUse(); $$=$1;}

	| Qualifier HISTORY			{$1->SetHistory(); $$=$1;}

	| Qualifier SELECT			{$1->SetSelect(); $$=$1;}

	| Qualifier ORPHAN			{$1->SetOrphan(); $$=$1;}

	|					{MenuType * New = new MenuType;
						/* above (=0) garbage avoids 
						 * bad warning message */
						New->Clear(); $$=New;}

MenuTitle : String 


MenuBody : 					{$$=StartItemList();}
						
	| MenuBody MenuItem 			{$1->List->Append($2->Item) ;
						$$=$1; delete $2;}

MenuInit : ',' MenuInitName 		{$$=$2;}	

	|				{$$=MakeNullValue();}

MenuInitName : Action LOCAL		{$$=MakeMenuInit($1,MENU_LOCAL);}

	| Action REMOTE			{$$=MakeMenuInit($1,MENU_REMOTE);}
							
	| Action REMOTE_OPTIONS		{$$=MakeMenuInit(
						$1,MENU_REMOTE_OPTIONS);}

Parameters : '(' ParameterList ')'		{$$=$2;}

	|					{$$=MakeParameterList();}

ParameterList : ParameterList ',' Parameter	{$$=MakeParameterList($1,$3);}

	| Parameter				{$$=MakeParameterList($1);}

Parameter : Number				{$$=$1;}

	| EXPLICIT_STRING			{$$=MakeParameter($1);}

	| MenuStackReference			{$$=MakeStackParameter($1);}

Number : INTEGER_VAL				{$$=MakeNumber($1);}

	| DOUBLE_VAL				{$$=MakeNumber($1);}

	| '-' INTEGER_VAL			{$$=MakeNegNumber($2);}

	| '-' DOUBLE_VAL			{$$=MakeNegNumber($2);}

PositiveInteger : INTEGER_VAL

MenuStackReference : '[' PositiveInteger ']' 	{$$=$2;}

							
Init : ',' InitName 			{$$=$2;}	

	|				{$$=MakeNullValue();}

InitName : Action LOCAL			{$$=MakeMenuInit($1,$2);}

	| Action REMOTE			{$$=MakeMenuInit($1,$2);}
							
	| Action REMOTE_OPTIONS		{$$=MakeMenuInit($1,$2);}
							
MenuItem :Command ',' Action  ActionType HelpRef Init ':' String Help HelpFile {
				$$=FoundMenuItem($1,$3,$4,$5,$6,$8,$9,$10); }

	| Command ',' Action  ActionType HelpRef Init ':' String HelpFile {
				$$=FoundMenuItem($1,$3,$4,$5,$6,$8,0,$9);}

	| Command ',' Action  ActionType Init ':' String Help HelpFile {
				$$=FoundMenuItem($1,$3,$4,0,$5,$7,$8,$9); }

	| Command ',' Action  ActionType Init ':' String HelpFile {
				$$=FoundMenuItem($1,$3,$4,0,$5,$7,0,$8);}

	| TEMPLATE ',' Action  ActionType Init ':' String HelpFile {
				$$=FoundItemTemplate($3,$4,0,$5,$7,0,$8);}

	| Command ITEM_REF		{$$=FoundItemRef($1);}

Command : WordString				{Found("Command");}

Action : Name Parameters 			{$$=MakeActionValue($1,$2);}
	
	| Name Parameters WAIT			{$$=MakeActionValue($1,$2,1);}

	| ORPHAN				{$$=MakeActionValue("Orphan");}

ActionType : LOCAL				{$$=MakeValue($1);}

	| REMOTE 				{$$=MakeValue($1);}

	| LOCAL_REMOTE 				{$$=MakeValue($1);}

	| REMOTE_OPTIONS			{$$=MakeValue($1);}

	| NEW_MENU				{$$=MakeValue($1);}

	| DYNAMIC_MENU				{$$=MakeValue($1);}

	| HELP_FILE				{$$=MakeValue($1);}

HelpRef : ',' NAME ITEM_HELP			{$$=$2;}

Operator : '%' 			{$$=MakeOperatorString('%');}
	| '/' 			{$$=MakeOperatorString('/');}
	| '<' 			{$$=MakeOperatorString('<');}
	| '>' 			{$$=MakeOperatorString('>');}
	| '^' 			{$$=MakeOperatorString('^');}
	| '|' 			{$$=MakeOperatorString('|');}
	| '?' 			{$$=MakeOperatorString('?');}
	| ':' 			{$$=MakeOperatorString(':');}
	| '+' 			{$$=MakeOperatorString('+');}
	| '-' 			{$$=MakeOperatorString('-');}
	| '*' 			{$$=MakeOperatorString('*');}
	| '&'			{$$=MakeOperatorString('&');}
	| SHIFT_R 		{$$=MakeOperatorString(SHIFT_R);}
	| SHIFT_L 		{$$=MakeOperatorString(SHIFT_L);}
	| LEQ 			{$$=MakeOperatorString(LEQ);}
	| GEQ 			{$$=MakeOperatorString(GEQ);}
	| EQU 			{$$=MakeOperatorString(EQU);}
	| NEQ 			{$$=MakeOperatorString(NEQ);}
	| AND 			{$$=MakeOperatorString(AND);}
	| OR 			{$$=MakeOperatorString(OR);}

Name : NAME					{$$=MakeValue($1);
							Found("Name");} 
	| OPERATOR Operator		{$$=MakeValue(MakeOperatorName($2));}

String : STRING					{$$=MakeValue($1);
							Found("String");}
	| Name					{Found("WordStringString");}

Help : TEXT

HelpFile : HELP_FILE STRING			{$$=$2;}

	| DEFAULT				{$$=MakeName(the_help_default_file);}

	|					{$$=0;}

StringChar : '%'				{$$='%';}

	| '!'					{$$='!';}

	| '^'					{$$='^';}

	| '&'					{$$='&';}

	| '|'					{$$='|';}

	| '$'					{$$='$';}

	| '+'					{$$='+';}

	| '-'					{$$='-';}

	| '/'					{$$='/';}

	| '*'					{$$='*';}


WordString : WordString  NAME			{$$=AddToWordString($1,$2);}

	| NAME					{$$=CreateWordString($1);}

	| WordString StringChar			{$$=ConcatWordString($1,$2);}

	| OPERATOR Operator	{$$=MakeValue(MakeOperatorName($2));}

	| WordString OPERATOR Operator	
				{$$=MakeValue(MakeOperatorCommand($1->Name,$3));}

