/*
 *  menmain.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProGen/cpyrght_exe.h"
#include <libc.h>
#include <fstream.h>
#include <string.h>
#include <getopt.h>
#include <iostream.h>
#include "menmain.h"
#include "mendir.h"
#include "stdyac.h"
#include "texmenu.h"
#include "menustr.h"
#include "mkstr.h"
#include "cgidbg.h"
#include "yacio.h"



const char * const Suffix = ".menu" ;

const char * TeXDirectory = 0 ;

void TeXProcess()
{
	static DynamicMenusToPrint DynamicPrint[] = {
		{"AddNodeOptMenu","Add"},
		{"InputNodeNodeOptMenu","InputNode"},
		{0,0}
	};
	static const ForceSectionLevel ForcedLevels[] = {
		{"AllCls",1},
		{0,0}
	};
	if (!TeXDirectory) return ;
	char * Temp = RemoveSuffix(CurrentFileName,Suffix);

	char * BaseName = ReplaceDirectory(TeXDirectory,Temp) ;
	delete Temp ;
	Temp = 0 ;
	
	TheTeXMenus = new TeXMenus(TheMenuDefs, DynamicPrint,ForcedLevels);

	// base.cls
	char * FileName = AddSuffix(BaseName,".cls");
	{
			ofstream Out(FileName);
			add_copyright_notice(FileName,Out);
			TheTeXMenus->TeXPrintClassHierarchy(Out);
	}

	// base.men
	delete FileName ;
	FileName = AddSuffix(BaseName,".men");
	{	
		ofstream Out(FileName);
		add_copyright_notice(FileName,Out);
		TheTeXMenus->TeXPrintMenuFile(Out);
	}

/*
 *	// base.ref
 *	delete FileName ;
 *	FileName = AddSuffix(BaseName,".ref");
 *	{
 *		ofstream Out(FileName);
 *		TheTeXMenus->TeXPrintMenuRefFile(Out);
 *	}
 *
 */
	// base.cmd
	delete FileName ;
	FileName = AddSuffix(BaseName,".cmd");
	{
		ofstream Out(FileName);
		add_copyright_notice(FileName,Out);
		cerr << "Print Command Ref File\n" ;
		TheTeXMenus->TeXPrintCommandRefFile(Out);
	}
	delete FileName ;
	// delete BaseName ;
}

static void Usage(const char * Cmd, int ExitCode=0)
{
	if (ExitCode) cerr << "Invalid command line.\n" ;
	cerr << " Usage is: " << Cmd <<
		" [-r][-l][-u UsrIncludeDir][-t TeXDirectory] File\n" ;
	cerr << " In addition -d enables yacc debugging.\n" ;
	exit(ExitCode);
}

#ifdef YYDEBUG
extern int yydebug ; // Yacc debugging flag.
#else
static int yydebug ;
#endif

main(int argc, char ** argv)
{
	yydebug = 0 ;
	SetNewHandler();
	int c;
	int errflg = 0;
	if (argc < 2) Usage(argv[0]);
	while (( c = getopt(argc,argv,"drlu:t:")) != EOF) switch(c) {
case 'l' :	RemoteFileFlag = 0;
		break ;
case 'r' :	LocalFileFlag = 0;
		break ;
case 'd' :
		yydebug = 1 ;
		break ;
case 't' :
		if (TeXDirectory) errflg ++ ;
		else TeXDirectory = optarg ;
		break ;
case 'u':
		if (!UsrInc) {
			UsrInc = optarg ;
			break ;
		}
default:
		errflg++;
		break ;
	}
	if (errflg) Usage(argv[0],1);
	int OneName = 0;
	for (; optind < argc; optind++) {
		if (OneName) {
			cerr << "Only one input file is allowed.\n" ;
			Usage(argv[0],1);
		}
		OneName = 1;
/*
 *		char * InputFileName = new char[strlen(argv[optind])+1];
 *		strcpy(InputFileName,argv[optind]);
 */
		char * InputFileName = ForceSuffix(argv[optind],Suffix);
	
		FILE * Temp = freopen(InputFileName,"r",stdin);
		if (!Temp) {
			cerr << "Cannot open input file `" << InputFileName <<
				"'\n" ;
			exit(2);
		}
		CurrentFileName = InputFileName ;
	}
	Process();
}

