/*
 *  rofftex.l from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
%start TEXT_MODE TS_OPTIONS TS_OPTIONS_PARAM TS_FORMAT TS_DATA CMD_MODE
%START VERB VERB_ONE 
	/* add code here with TAB at start of each line */
%a 18000
%p 16000
%n 4000
%o 40000
%e 2000
%% TEXT_MODE
\\\"\.CAPTION			{
					BEGIN CMD_MODE;
					CaptionOn=1;
					ClearCaptionIndexTable();
					return CAPTION;
				}
\\\"\.LINE			{
					BEGIN VERB_ONE;
					return TABLE_REPLACE_LINE;
				}
<VERB_ONE>.*$			{
					BEGIN TEXT_MODE ;
					yylval.String = MakeLitString(yytext);
					return VERBATIM_LINE ;
				}
\\\"[^\.\n].*$			|
\\\"$				Dbg cerr<< "Comment `"<<yytext<<"'\n";// comment
<CMD_MODE>\n			{BEGIN TEXT_MODE; CaptionOn = 0; LineNumber++;}
^\.P				{BEGIN CMD_MODE; return ROFF_P ;}
^\.H				{BEGIN CMD_MODE; return ROFF_H ;}
^\.ALA				{BEGIN CMD_MODE; return ROFF_AL ;}
^\.AL				{BEGIN CMD_MODE; return ROFF_AL ;}
^\.LI				{BEGIN CMD_MODE; return ROFF_LI ;}
^\.LE				{BEGIN CMD_MODE; return ROFF_LE ;}
^\.TC				BEGIN CMD_MODE ;
^\.NF.*\n			{BEGIN VERB; LineNumber++; return ROFF_NF ;}
^\.FI				{BEGIN CMD_MODE; return ROFF_FI ;}
^\.TS				{BEGIN TS_OPTIONS; return ROFF_TS ;}
<VERB>^\n			{
					LineNumber++ ;
					return EMPTY_VERBATIM ;
				}
<VERB>^[^\.\n].*$		{
					yylval.String = MakeLitString(yytext);
					return VERBATIM_LINE ;
				}
<CMD_MODE>[ \t]+		;
<CMD_MODE>\"[^\n\"]*\"	{
					Dbg cerr << "Found QUOTED_STRING\n" ;
					const char * Ret = MakeString(yytext);
					if (!CaptionOn) Ret = TeXString(Ret);
					yylval.String = Ret ;
					if (CaptionOn) return CAPTION_STRING ;
					return QUOTED_STRING ;
				}
<TS_OPTIONS>\ *			;
<TS_OPTIONS>[a-z]+		{
					Dbg cerr << "TABLE_OPTIONS\n" ;
					yylval.TabOptSel = ExpandOption(yytext);
					return TABLE_OPTIONS ;
				}
<TS_OPTIONS>\(			BEGIN TS_OPTIONS_PARAM ;
<TS_OPTIONS_PARAM>.\)		{
					Dbg cerr << "TS_OPTION_PARAMETER 1\n" ;
					char * Temp = new char[2] ;
					Temp[0] = yytext[0];
					Temp[1] = '\0' ;
					yylval.String = Temp ;
					return TS_OPTION_PARAMETER ;
				}
<TS_OPTIONS_PARAM>..\)		{
					Dbg cerr << "TS_OPTION_PARAMETER 2\n" ;
					yylval.String = MakeLitString(yytext);
					return TS_OPTION_PARAMETER ;
				}
<TS_OPTIONS_PARAM,TS_OPTIONS>\ *	;
<TS_OPTIONS_PARAM,TS_OPTIONS>\;		{
					Dbg cerr << "BEGIN TS_FORMAT\n" ;
					BEGIN TS_FORMAT ;
				}
<TS_FORMAT>[LlRrCcNnAaSs_=\|]+\. {
					Dbg cerr << "TABLE_FORMAT\n" ;
					BEGIN TS_DATA ;
					yylval.String = MakeLitString(yytext);
					return TABLE_FORMAT ;
				}
<TS_DATA>^\.TE			{
					Dbg cerr << "END_OF_TABLE: ROFF_TE\n" ;
					BEGIN TEXT_MODE ;
					return ROFF_TE ;
				}
<TS_DATA>\t			return TAB ;
<TS_DATA>\ *			;
<TS_DATA>[^\ \t\n][^\t\n]*[^\ \t\n]* |
<TS_DATA>[^\t\n]		{
					Dbg cerr << "TABLE_ENTRY\n" ;
					Dbg cerr << "`" << yytext << "'\n" ;
					yylval.String = TeXString(yytext);	
					return TABLE_ENTRY ;
				}
<TS_DATA>\\\\\n			{
					Dbg cerr << "Table continue\n" ;
					LineNumber++ ;
					/* continue line */		
				}
<TS_DATA>\n			{
					Dbg cerr << "END_OF_TABLE_LINE\n" ;
					LineNumber++ ;
					return END_OF_TABLE_LINE ;
				}
<TEXT_MODE>^[^\.\\\n].*	|
<TEXT_MODE>^\\[^\n\"].*	{
					Dbg cerr << "Found TEXT_LINE\n" ;
					Dbg cerr << "`" << yytext << "'\n" ;
					yylval.String = TeXString(yytext);
					return TEXT_LINE ;
				}
0[0-7]*				{
					yylval.Int = OctConvert(yytext);
					return INTEGER_VAL ;
				}
[1-9][0-9]*			{
					yylval.Int = IntConvert(yytext);
					return INTEGER_VAL ;
				}
0[xX][0-9a-fA-F]*		{	
					yylval.Int = HexConvert(yytext+2);
					return INTEGER_VAL ;
				}
\n				{
					LineNumber++;
					Dbg cerr<<"Line "<< LineNumber << "\n";
				}
\-					return yytext[0] ;
\=					|
\+					|
\&					|
\|					|
\%					|
\~					|
\!					|
\^					|
\/					|
\<					|
\>					|
\:					|
\?					|
\*					|
\[					|
\]					|
\)					|
\(					|
\,					|
\;					|
\{					|
\}					|
.					IllegalChar(yytext[0]);
