/*
 *  exeparamd.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "menucmdd.h"
#include "defined.h"
void ExecuteCmdDsp::DoCall()
{
	switch(Params->ParameterType) {
case 0:
		TheCall();
		break;
case 1:
		TheCall(GetMenuStackName(Params->StackParameters[0]));
		break;
case 2:
		TheCall(GetMenuStackName(Params->StackParameters[0]), 
			Params->StringParameters[0]);
		break;
case 3:
		TheCall(Params->StringParameters[0]);
		break;
case 4:
		TheCall(Params->StringParameters[0], 
			GetMenuStackName(Params->StackParameters[0]));
		break;
case 5:
		TheCall(Params->StringParameters[0], 
			Params->StringParameters[1]);
		break;
case 6:
		TheCall(Params->StringParameters[0], 
			GetMenuStackName(Params->StackParameters[0]), 
			Params->StringParameters[1]);
		break;
case 7:
		TheCall(GetMenuStackName(Params->StackParameters[0]), 
			GetMenuStackName(Params->StackParameters[1]), 
			Params->StringParameters[0]);
		break;

	}
}

ParameterizedActionCall AllActions[] = {
	(ParameterizedActionCall) DoSaveExit, 
	(ParameterizedActionCall) DoExit, 
	(ParameterizedActionCall) node_trace_on, 
	(ParameterizedActionCall) node_trace_off, 
	(ParameterizedActionCall) heap_check_on, 
	(ParameterizedActionCall) heap_check_off, 
	(ParameterizedActionCall) set_report_overflow_limit, 
	(ParameterizedActionCall) ListInt, 
	(ParameterizedActionCall) ListDouble, 
	(ParameterizedActionCall) ListMachWord, 
	(ParameterizedActionCall) ListAccMachWord, 
	(ParameterizedActionCall) DoSave, 
	(ParameterizedActionCall) DoSaveAs, 
	(ParameterizedActionCall) DoSavePeriod, 
	(ParameterizedActionCall) SetStateSaveFile, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) MemberFunctionDescribe, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) MemberFunctionDescribe, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) MemberFunctionDescribe, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) MemberFunctionDescribe, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) MemberFunctionDescribe, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) MemberFunctionDescribe, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) MemberFunctionDescribe, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) ExecuteMemberFunction, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) MemberFunctionDescribe, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) DescribeMemberFunctionParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) ExecuteSetParameter, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) MemberFunctionDescribe, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) DescribeParamInstance, 
	(ParameterizedActionCall) CreateDefaultNodeInteractiveEntity, 
	(ParameterizedActionCall) CreateNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeNodeInstance, 
	(ParameterizedActionCall) DeleteNodeInteractiveEntity, 
	(ParameterizedActionCall) DescribeParam, 
	(ParameterizedActionCall) DescribeParamInstance
};

void DoSaveExit();
void DoExit();
void node_trace_on();
void node_trace_off();
void heap_check_on();
void heap_check_off();
void set_report_overflow_limit();
void ListInt();
void ListDouble();
void ListMachWord();
void ListAccMachWord();
void DoSave();
void DoSaveAs();
void DoSavePeriod();
void SetStateSaveFile();
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void MemberFunctionDescribe(const char *, const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void MemberFunctionDescribe(const char *, const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateNodeInteractiveEntity(const char *);
void MemberFunctionDescribe(const char *, const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void MemberFunctionDescribe(const char *, const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void MemberFunctionDescribe(const char *, const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void MemberFunctionDescribe(const char *, const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void MemberFunctionDescribe(const char *, const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void ExecuteMemberFunction(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void MemberFunctionDescribe(const char *, const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void DescribeMemberFunctionParameter(const char *, const char *, 
	const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void ExecuteSetParameter(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void MemberFunctionDescribe(const char *, const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
void CreateDefaultNodeInteractiveEntity(const char *);
void CreateNodeInteractiveEntity(const char *);
void DescribeNodeInstance(const char *, const char *);
void DeleteNodeInteractiveEntity(const char *, const char *);
void DescribeParam(const char *, const char *);
void DescribeParamInstance(const char *, const char *, const char *);
