/*
 *  yacintfc.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef YACINTFC_DOT_H
#define YACINTFC_DOT_H
/*  yacintfc.h   */
/*  Copyright 1990 Mountain Math Software  */
/*  All Rights Reserved                    */
class CommandState {
	char SemanticErrorFlag ;
	char PreviousErrorFlag ;
	char Exiting ;
	const char * the_log_file ;
	int max_warn ;
	int warn_count ;
public:
	CommandState () ;
	void SetError() {SemanticErrorFlag = PreviousErrorFlag = 1;}
	void ClearError() {SemanticErrorFlag = 0;}
	int IsError() {return SemanticErrorFlag; }
	int IsPreviousError() {return PreviousErrorFlag;}
	int IsInteractive() { return 0;}
	int IsConfirm() {return 1;}
	
	void Error(const char * a, const char * b =0, const char * c=0,
		const char *  d=0, const char * e=0, const char * f =0,
		const char * g = 0, const char * h=0);

	void Warning(const char * a, const char * b =0, const char * c=0,
		const char *  d=0, const char * e=0, const char * f =0,
		const char * g = 0, const char * h=0);
	int is_exiting() {return Exiting;}
    void set_exiting() {Exiting = 1 ;}
	void log_file(const char *file) {the_log_file = file;}
	const char * log_file () const { return the_log_file;}
	void warn(int set) {warn_count = set ;}
	int warn() const {return warn_count ;}
	static int warn_def ;
	void end_node_exec();
} ;

extern CommandState State ;

#endif /* #ifdef YACINTFC_DOT_H */
