/*
 *  buffer.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef BUFFER_DOT_H
#define BUFFER_DOT_H
#include "ObjProArith/hrdarth.h"
#include "ObjProGen/errcode.h"

class TargetNode ;

enum BufferState {BufferOK=0, BufferEndOfData, BufferEndOfDataEmpty,
	BufferWrapRead, BufferWrapWrite};

struct OutputBuffer ;

struct BufferReadStatus {
	enum BufferState TheState ;
	int ReadPtr ;
	int FullFlag ; /* if ReadPtr == WritePtr this differentiates */
	ErrCode Reset();
};

struct OutputBuffer {
	MachWord * Data ;
	int Size ;
	int Readers ;
	TargetNode * DriverNode ;
	struct BufferReadStatus * ReadersStatus ;
	int WritePtr ;
	int SufficientData ;
	int32 GetAvailableData(int Index=0) const ;
	int32 GetContiguousAvailableData(int Index=0) const ;
	int32 GetAvailableSpace() const ;
	int32 GetContiguousAvailableSpace() ;
	MachWord * GetPtrWriteWord();
	void WriteBinary(BinMachWord Data)
		{*((BinMachWord *) GetPtrWriteWord()) = Data ;}
	void WriteWord(MachWord Data)
		{ *(GetPtrWriteWord()) = Data ;}
	MachWord * ReadPtrWord(int Index=0);
	MachWord ReadWord(int Index=0){return *ReadPtrWord(Index);}
	BinMachWord ReadBinary(int Index=0)
		{ return *(BinMachWord *) ReadPtrWord(Index);}
	void WriteCxWord(CxMachWord Data);
	CxMachWord ReadCxWord(int Index=0);

	MachWord * GetBase() {return Data;}
	BinMachWord * GetBinBase() {return (BinMachWord *) Data;}
	
	MachWord * GetEnd() {return Data + Size ;}
	BinMachWord * GetBinEnd() {return (BinMachWord *) Data + Size ;}
	
	BinMachWord * GetBinWritePtr() const
		{return (BinMachWord *) (Data + WritePtr);}
	MachWord * GetWritePtr() const { return Data + WritePtr;}
	const MachWord * GetReadPtr(int chan) const
		{return ReadersStatus[chan].ReadPtr + Data ; }
	const BinMachWord * GetBinReadPtr(int chan) const
		{return (BinMachWord *) (ReadersStatus[chan].ReadPtr + Data) ; }
	void UpdateRead(int index, int32 size);
	void UpdateWrite(int32 size);
	ErrCode Reset() ;
};

extern MachWordType TheSharedBuffer[] ;

#endif /* #ifdef BUFFER_DOT_H */
