/*
 *  usrprompt.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef USRPROMPT_DOT_H
#define USRPROMPT_DOT_H
#include "usriotyp.h"
#include "textdefs.h"

class TextWindow ;

class UserPrompt {
	InputType Type;
	SuspendedRead Client ;
	const char * Prompt;
	const char * the_default_string ;
	void * Object ;
	int ChangeActive;
	int DeletePrompt ;
public:
	UserPrompt(const char * prompt, SuspendedRead client,
		void * object = 0, int change_active = 1,
		int delete_prompt = 1, InputType type = InputPrompt,
		const char * def=0);
	UserPrompt(InputType type, const char * prompt, SuspendedRead client,
		void * object = 0, int change_active = 1,
		int delete_prompt = 1, const char *def=0);
	~UserPrompt();
	InputType GetType() {return Type;}
	SuspendedRead GetClient() {return Client;}
	const char * GetPrompt() {return Prompt;}
	void * GetObject() {return Object;}
	int  IsChangeActive() {return ChangeActive;}
	void ClearChangeActive() {ChangeActive = 0;}
	void NewPrompt(const char * Prompt, int NewDeletePrompt = 1) ;
	int IsPromptString() ;
	int WritePrompt(TextWindow *Win) ;
	const char * default_string() const {return the_default_string;}
	void capture_read();
};

enum PromptStatus {PromptStatusOk, PromptStatusAbort};

inline UserPrompt * UserPromptNoChange(const char * prompt,
	SuspendedRead client,
	void * object = 0, int delete_prompt = 1, InputType type = InputPrompt)
{
	return new UserPrompt(prompt,client,object,0,delete_prompt,type) ;
}

inline UserPrompt * UserPromptNoChangeSave(const char * prompt,
	SuspendedRead client,
	void * object = 0, InputType type = InputPrompt)
{
	return new UserPrompt(prompt,client,object,0,0,type) ;
}

inline UserPrompt * UserPromptSave(const char * prompt, SuspendedRead client,
	void * object = 0, int change_active = 1, InputType type = InputPrompt)
{
	return new UserPrompt(prompt,client,object,change_active,0,type) ;
}

PromptStatus PrepareToWriteFile(const char * FileName, SuspendedRead,
	void * Object, const char * AbortMessage) ;


#endif /* #ifdef USRPROMPT_DOT_H */
