/*
 *  menmgr.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "xdrv.h"
#include <stream.h>
#include <InterViews/leave-scope.h>
#include <Dispatch/leave-scope.h>
#include "cgidbg.h"
#include "menu.h"

#include "menmgr.h"

void MenuViewList::about_to_change_menu(Menu * to_change)
{
	if (!to_change) DbgError("MenuViewList::about_to_change_menu",
		"null menu");
	// LogOut << "MenuViewList::about_to_change_menu("<<(void*)to_change<<"\n" ;
	// LogOut << "`" << to_change->GetHeader() << "'\n" ;
	MenuViewListIterator Next(*this);
	MenuView * check ;
	MenuViewList to_delete ;
	while (check = Next())
	  if (check->about_to_change_menu(to_change)) {
			// LogOut << "Request to delete:" << (void *) check << "\n" ;
			to_delete.Append(check);
	}
	MenuViewListIterator Nex(to_delete);
	while (check = Nex()) {
		// LogOut << "Deleting " << (void *) check << "\n" ;
		check->exit_window() ;
	}
}

