/*
 *  myfloat.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <math.h>

#include "myfloat.h"

#include "dspguicom.h"
#include "arthnm.h"

const char * DspGuiCommon::default_prefix = 
	"Type RETURN to select the default value (" ;

const char * DspGuiCommon::default_suffix =  ") for `" ;



const char * FloatFormat(double value)
{
	double AbsValue = fabs(value);
	if (AbsValue < 1.e9 && AbsValue > 1.e-5) return "%f" ;
	return "%e" ;
} 
