/*
 *  bits.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#include <iostream.h>

#include "bits.h"

GetBits::GetBits(const GetBits& bits)
{
	MaxBits = bits.GetMaxBits();
	Words = new uint32[(MaxBits>>5) + 1] ;
	for (int i = 0 ; i <= (MaxBits>>5); i++)
		Words[i] = bits.GetWord(i);
	Reset();
}

uint32 GetBits::GetWord(int i) const
{
	if (i > (MaxBits >> 5)) return 0 ;
	return Words[i] ;
}

GetBits& GetBits::operator|=(const GetBits& bit)
{
	for (int i = 0; i <= (MaxBits >> 5); i++) {
/*
 *		cerr << "0x" << hex << Words[i]  << " |= 0x" <<
 *			bit.GetWord(i) << dec << "\n" ;
 */
		Words[i] |= bit.GetWord(i);

	}
	return *this ;
}

int GetBits::NextBit()
{
	for (LastRead ++ ; LastRead < MaxBits ; LastRead++) 
		if (BitMask() & Words[WordIndex()]) return LastRead ;
	return LastRead = -1 ;
}
		
void GetBits::SetBit(int Bit)
{
	int word = Bit >> 5 ;
	int Dist = Bit - (word << 5) ;
	unsigned Value = ((unsigned) 1) << (31 - Dist) ;
	Words[word] |= Value ;
}

void GetBits::Display()
{
	// cout<< "LastRead = " << LastRead <<", MaxBits = " << MaxBits << "\n";
	// for (int i =0 ; i < ((MaxBits+31)>>5) ;i++) {
	//	cout << " 0X" << hex(Words[i],8) ;
	// }
	// cout << "\n" ;
}
