/*
 *  signode.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/signode.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * SignalStrNodeList = 0 ;
static InteractiveEntity * IntEntSignalStr ;
void SignalStrNodesInit();
SignalStr::SignalStr (const char * Name, int16 procOut, StreamStr*procStrOut, 
		int32 procIncOut, TimingType procTheTimingType):
	Node(Name, 0, procOut, 0, procStrOut, 0, 1, procIncOut, 0, 0, 
	procTheTimingType)
,
	procOut_1(procOut),
	procStrOut_2(procStrOut),
	procIncOut_3(procIncOut),
	procTheTimingType_4(procTheTimingType)
{
} // end constructor

SignalStr::~SignalStr()
{
} // end destructor

int SignalStr::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

static ValueType * Raise(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextQuoteOut("Raise");
		Out.NextFillOut("will cause a window displaying this network to be raised");
		Out.NextFillOut("to the top level over any overlapping windows.");
		Out.NextFillOut("Examples of windows that will be affected are a network display");
		Out.NextFillOut("containing this node or a plot window for this node.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((SignalStr * )This)->Raise(
		);		}
	}
	return 0;
}

static ValueType * SetSampleRate(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("The");
		Out.NextQuoteOut("SetSampleRate");
		Out.NextFillOut("member function sets the sample");
		Out.NextFillOut("rate for the specified output channel of this node.");
		Out.NextFillOut("In turn the rates for all input and output channels connected");
		Out.NextFillOut("to this node are adjusted with one exception.");
		Out.NextFillOut("The adjustment will");
		Out.NextFillOut("not be made through a node output channel that specifies");
		Out.NextFillOut("a timing relationship of");
		Out.NextFillOut("`TimingTypeRandom'");
		Out.NextFillOutConcat(".");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		double Rate =
			Param->GetFloatParameterValue("Rate");
		int16 Channel =
			Param->GetIntParameterValue("Channel");

		((SignalStr * )This)->SetSampleRate(
		Rate, Channel);		}
	}
	return 0;
}

static ValueType * DisplayOutputTiming(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("DisplayOutputTiming");
		Out.NextFillOut("displays the timing");
		Out.NextFillOut("of the selected output channel for this node.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{		int16 Channel =
			Param->GetIntParameterValue("Channel");

		((SignalStr * )This)->DisplayOutputTiming(
		Channel);		}
	}
	return 0;
}

static ValueType * Edit(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("If this node is not linked in an existing network it will be");
		Out.NextFillOut("added to the display of the network currently being edited. If");
		Out.NextFillOut("there is no such network one will be created.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((SignalStr * )This)->Edit(
		);		}
	}
	return 0;
}

static ValueType * Unlink(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("Member function");
		Out.NextQuoteOut("Unlink");
		Out.NextFillOut("disconnects this node from the");
		Out.NextFillOut("DSP network it is linked in. All nodes that are connected");
		Out.NextFillOut("as outputs from this node will be unlinked. This process");
		Out.NextFillOut("continues recursively up to the terminal output nodes of all");
		Out.NextFillOut("affected threads. Unlinking the first node in a single");
		Out.NextFillOut("thread network will unlink every node in the network.");
		Out.NextFillOut("If a node has two or more inputs and only one of these is unlinked");
		Out.NextFillOut("the node will remain connected to the network");
		Out.NextFillOut("on the unaffected input channel or channels.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((SignalStr * )This)->Unlink(
		);		}
	}
	return 0;
}

static ValueType * NextFreeOutput(OutTokens& Out,EntityReq Request,
		UserParameters * Param,UserEntity *This) 
{
	switch (Request) {
case EntityReqDescribe:
case EntityReqDescribeFull:
		Out.NextFillOut("This function displays the next available output link for this node.");
		Out.NewLine();

	break ;
case EntityReqCall:
		{
		((SignalStr * )This)->NextFreeOutput(
		);		}
	}
	return 0;
}

void SignalStrNodesInit()
{
	if (SignalStrNodeList)  return ;
	static OneParameter RaiseSignalStrList[] = {
		{0}
	};
	UserParameters * RaiseMemberParam = new UserParameters
		(RaiseSignalStrList);

	Procedure * MemberProcRaise = new Procedure("Raise", Raise,
		RaiseMemberParam, "void", 0, "raise any window referencing this node");
	static FloatParam SignalStrSetSampleRateRateParam = {
		 1.0, 0,  0,  1.e-60,  0,  1.e60};
	static IntParam SignalStrSetSampleRateChannelParam = {
		 0, 0,  0,  0, 0, 32767};
	static OneParameter SetSampleRateSignalStrList[] = {
		{"Rate", 0, "sample rate for node output"
			, 0, &SignalStrSetSampleRateRateParam},
		{"Channel", 0, "output channel to set sample rate for"
			, &SignalStrSetSampleRateChannelParam, 0, 0, 0, 0, 1},
		{0}
	};
	UserParameters * SetSampleRateMemberParam = new UserParameters
		(SetSampleRateSignalStrList);

	Procedure * MemberProcSetSampleRate = new Procedure("SetSampleRate", SetSampleRate,
		SetSampleRateMemberParam, "void", 0, "set the sample rate for the network");
	static IntParam SignalStrDisplayOutputTimingChannelParam = {
		 0, 0, 0, -32767, 0, 32767};
	static OneParameter DisplayOutputTimingSignalStrList[] = {
		{"Channel", 0, "output channel to display timing for"
			, &SignalStrDisplayOutputTimingChannelParam, 0, 0, 0, 0, 1},
		{0}
	};
	UserParameters * DisplayOutputTimingMemberParam = new UserParameters
		(DisplayOutputTimingSignalStrList);

	Procedure * MemberProcDisplayOutputTiming = new Procedure("DisplayOutputTiming", DisplayOutputTiming,
		DisplayOutputTimingMemberParam, "void", 0, "display the timing of the selected output channel");
	static OneParameter EditSignalStrList[] = {
		{0}
	};
	UserParameters * EditMemberParam = new UserParameters
		(EditSignalStrList);

	Procedure * MemberProcEdit = new Procedure("Edit", Edit,
		EditMemberParam, "void", 0, "make this node available for editing in a graphical network");
	static OneParameter UnlinkSignalStrList[] = {
		{0}
	};
	UserParameters * UnlinkMemberParam = new UserParameters
		(UnlinkSignalStrList);

	Procedure * MemberProcUnlink = new Procedure("Unlink", Unlink,
		UnlinkMemberParam, "void", 0, "unlink this node and nodes connected to its output ");
	static OneParameter NextFreeOutputSignalStrList[] = {
		{0}
	};
	UserParameters * NextFreeOutputMemberParam = new UserParameters
		(NextFreeOutputSignalStrList);

	Procedure * MemberProcNextFreeOutput = new Procedure("NextFreeOutput", NextFreeOutput,
		NextFreeOutputMemberParam, "void", 0, "display next free output link");
static ValueType * SignalStrMembers[7] ;
	int ii = 0 ;
	SignalStrMembers[ii++] = new ValueType(DecProcedure, MemberProcRaise) ;
	SignalStrMembers[ii++] = new ValueType(DecProcedure, MemberProcSetSampleRate) ;
	SignalStrMembers[ii++] = new ValueType(DecProcedure, MemberProcDisplayOutputTiming) ;
	SignalStrMembers[ii++] = new ValueType(DecProcedure, MemberProcEdit) ;
	SignalStrMembers[ii++] = new ValueType(DecProcedure, MemberProcUnlink) ;
	SignalStrMembers[ii++] = new ValueType(DecProcedure, MemberProcNextFreeOutput) ;
	SignalStrMembers[ii++] = 0 ;
	SignalStrNodeList = new EntityList;
	IntEntSignalStr = new InteractiveEntity("SignalStr", SignalStrNodeList,
		0, InteractiveNode, "signode.h",
		SignalStrMembers, "Node");
	TheNodes->Append(IntEntSignalStr);
} // end initalization

static InitObj LocalInit(SignalStrNodesInit, "SignalStr", "Node");

