/*
 *  sigbase.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/sigbase.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
static EntityList * SignalNodeList = 0 ;
static InteractiveEntity * IntEntSignal ;
void SignalNodesInit();
Signal::Signal (const char * Name, int16 procOut, int32 procEltSz, int32 procIncOut, 
		int32 procBlockSize, TimingType procTheTimingType, 
		ArithType::ArithCapabilities procArithTypeOut):
	SignalStr(Name, procOut, 
	 new StreamStr(procEltSz , procBlockSize , procArithTypeOut), procIncOut, procTheTimingType)
,
	procOut_1(procOut),
	procEltSz_2(procEltSz),
	procIncOut_3(procIncOut),
	procBlockSize_4(procBlockSize),
	procTheTimingType_5(procTheTimingType),
	procArithTypeOut_6(procArithTypeOut)
{
} // end constructor

Signal::~Signal()
{
} // end destructor

int Signal::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

void SignalNodesInit()
{
	if (SignalNodeList)  return ;
	SignalNodeList = new EntityList;
	IntEntSignal = new InteractiveEntity("Signal", SignalNodeList,
		0, InteractiveNode, "sigbase.h",
		0, "SignalStr");
	TheNodes->Append(IntEntSignal);
} // end initalization

static InitObj LocalInit(SignalNodesInit, "Signal", "SignalStr");

