/*
 *  dyplot.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <complex.h>
#include "ObjProArith/hrdarth.h"
#include "ObjProGui/sigintfc.h"
#include "ObjProComGui/cgidbg.h"
#include "ObjProDSP/pltenm.h"
#include "ObjProNet/dfnode.h"

#include "ObjProUsr/dyplot.h"
#include "ObjProGen/outtok.h"
#include "ObjProGui/intfc.h"
#include "ObjProGui/remmen.h"
#include "ObjProGui/user.h"
#include "ObjProGui/dynmnu.h"
#include "ObjProArith/typout.h"
#include "ObjProGui/array.h"
#include "ObjProGui/interinit.h"
#include "ObjProGen/stattyp.h"
#include "ObjProGui/yacintfc.h"
static EntityList * PlotNodeList = 0 ;
static InteractiveEntity * IntEntPlot ;
void PlotNodesInit();
Plot::Plot (const char * Name, const char * Caption):
	GenericBlockPlotStr(Name, 
	 new StreamStr(SizeVariable , SizeVariable , ArithType::ArithCapabilityAny), Caption, 0.000000e+00, 0.000000e+00, 0.000000e+00, 0.000000e+00, 
	1, 0, TimingTypeLinear, PlotDynDyn)
,
	Caption_1(Caption)
{
	if (!PlotNodeList) PlotNodesInit() ;
	PlotNodeList->Append(MakeDeclaredEntity(this, IntEntPlot)) ;
	InitArithType(TheArithType);
	NewMenuItem("Plot",GetName());
#line 43 "../dyplot.usr"
 
#ifdef INTERACTIVE
	set_delete_if_unlinked();
#endif
#line 47 "../dyplot.C"
} // end constructor

Plot::~Plot()
{
	TheMenuServer->DeleteMenuItem("Plot",GetName());
	PlotNodeList->Delete(GetName()) ;
} // end destructor

int Plot::CheckSafeDelete()
{
	int Safe_Check_Return = DfNode::CheckSafeDelete();
	if (!Safe_Check_Return) return 0;
	return 1;
} // end check safe delete

double Plot::TimeFirst( DfNodeInLink * , DfNodeOutLink * )
{
#line 66 "../dyplot.usr"
	return 0.0;
	// timing is irrelevant for a node with no output channels
#line 68 "../dyplot.C"
} // end timing code

Plot * PlotDef;

ErrCode Plot::DoNode(int32 k)
{
#line 71 "../dyplot.usr"
 
	if (State.IsError()) return FatalError ;
	CheckSetup() ;
	// int count = 0 ;
	int BlockS = 1 ;
	int EltSz = GetDriverElementSize(0);
	if (GetBlockSize()) BlockS = GetBlockSize() ;
	for (int32 i = 0 ; i < k ; i++ )
	    for (int32 j = 0 ; j < EltSz; j++)
	    for (int32 l = 0 ; l < BlockS; l++) {
			if (State.IsError()) return FatalError ;
			MachWord Next ;
			if (binary_read_flag) Next = ReadBinary();
			else Next = ReadWord();
			WriteDataWord(Next);
			// count++ ;
	}
	// LogOut << "Wrote " << count << "words.\n" ;
	WriteBuffer(0);
	return OK ;
#line 96 "../dyplot.C"
} // end kernel code

static UserEntity * MakePlot(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith = (ArithType::ArithCapabilities) TheArithType) ;
int Plot::CppList(OutTokens& Out, CppListCmds Cmd)
{
	return IntEntPlot->CppList(Out,Cmd,this);
}

void Plot::Describe(OutTokens& Out, ListEntity Option)
{
	switch(Option) {
case ListSingleEntity:
		Out.NewLine();
		MakePlot(Out,EntityReqDescribeFull,*IntEntPlot,TheArithType);
		Out.NewLine();
		Out.NextFillOut("The");
		Out.NextQuoteOut("Caption");
		Out.NextQuoteOut(GetCaption());
		Out.NextFillOut("is displayed");
		Out.NextFillOut("at the base of the plot. The default value of 0");
		Out.NextFillOut("causes the plot node name to be used for the caption.");
		Out.NextFillOut("The caption cannot contain blanks. Use underscore instead.");
		Out.NewLine();
		break;
case ListEntityMembers:
		Out.NextOut(GetName());
		break;
case ListGlobalClasses:
case ListEntityClasses:
		break ;
case ListSetParameterValues:
		IntEntPlot->GetOneParameter("Caption")->
			StringP->CurrentValue = Caption_1;
		break;
	}
} // end  list entity switch

void PlotNodesInit()
{
	if (PlotNodeList)  return ;

	static StringParam PlotNameParam =
		{"Plot", MakeNewEntityName, 0, LegalEntityName};
	static StringParam PlotCaptionParam = {
		 0, 0, 0};

	static OneParameter PlotParArray[] = {
		{"Name", 0, "node name", 0, 0, &PlotNameParam},
		{"Caption", 0, 
			"plot caption",
			0, 0, &PlotCaptionParam},
		{0}
	};

	PlotNodeList = new EntityList;
	IntEntPlot = new InteractiveEntity("Plot", PlotNodeList,
		MakePlot, InteractiveDisplay, "dyplot.h",
		0, "GenericBlockPlotStr");
	IntEntPlot->SetParameters(new UserParameters(PlotParArray));
	TheNodes->Append(IntEntPlot);
} // end initalization

static UserEntity * MakePlot(OutTokens& Out, EntityReq Request,
	InteractiveEntity& IntNode,
	ArithType::ArithCapabilities arith)
{
	switch(Request) {
case EntityReqDescribe:

case EntityReqDescribeFull:
		Out.NextQuoteOut("Plot");
		Out.NextFillOut("displays signals in graphical form.");
		Out.NextFillOut("The plot can be captioned by setting");
		Out.NextQuoteOut("Caption");
		Out.NextFillOutConcat(".");
		Out.NextFillOut("If");
		Out.NextQuoteOut("Caption");
		Out.NextFillOut("is the default (0) a caption is constructed");
		Out.NextFillOut("from the plot node name and the name of its driver node.");
		Out.NextFillOut("The data is auto-scaled. You can display it with a fixed scale and");
		Out.NextFillOut("alternate between the default full scale display and a  fixed scale.");
		Out.NextFillOut("See the help file on `change plot detail' accessible under `Help' in the menu bar");
		Out.NextFillOut("in any plot window.");
		Out.NewLine();
		break;

case EntityReqCreate:
	{
		const char * Name = IntNode.GetStringParameterValue("Name");
		const char * Caption =
			IntNode.GetStringParameterValue("Caption");
		return new Plot(Name, Caption);

	}
	}
	return 0;
}

static InitObj LocalInit(PlotNodesInit, "Plot", "GenericBlockPlotStr");

