/*
 *  replc.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "replc.h"
#include "dfnode.h"
#include "network.h"
#include "netlnk.h"
#include "yacintfc.h"
#include "portable.h"
#include "cgidbg.h"
#include "netcnt.h"

// void TestAlloc(const char * msg);

ReplaceNodeLinks::ReplaceNodeLinks(DfNode& nd):
	node(nd),
	in(nd.GetIn()),
	out(nd.GetOut()),
	inputs(0),
	outputs(0)
{
	if (in) inputs = new ReplaceInLink[in] ;
	if (out) outputs = new ReplaceOutLink[out] ;
	for (int i = 0 ; i < in ; i++) {
		inputs[i].node = 0 ;
		inputs[i].channel_from = -1 ;

		DfNodeOutLink * out_link = node.GetDriverOutputChannel(i);
		if (!out_link) continue ;
		DfNode * driver = out_link->GetDriverNode();
		if (!driver) continue ;

		DfNodeLink * link = out_link->GetOutLink();
		if (!link) continue ;

		DfNodeIn * in_link = link->GetInputLink();
		
		inputs[i].node = driver ;
		inputs[i].channel_from = in_link->GetIndex();
	}
	for (i = 0 ; i < out ; i++) {
		outputs[i].channel_from = -1 ;
		outputs[i].size = 0 ;
		outputs[i].buf_links = 0 ;
		DfNodeOutLink * out_link = node.GetOutLink(i);
		if (!out_link) continue ;
		DfNodeLink * link = out_link->GetOutLink();
		if (!link) continue ;
		int32 size = link->Size();
		if (!size) continue ;
		outputs[i].size = size ;
		outputs[i].buf_links = new ReplaceOutBufferLink[size] ;
		// LogOut << "outputs[" << i << "] is size " << size << "\n" ;
		DfNodeOutList * links = link->GetOutputLinks();
		if (!links) DbgError("ReplaceNodeLinks::ctor",
			"size and links inconsistent");

		DfNodeOut * out ;
		DfNodeOutIterator Next(*links) ;
		for (int j = 0 ; out=Next() ; j++) {
/*
 *			LogOut << "setting output channel " << i << ", buffer channel "
 *				<< j << "\n" ;
 */
			ReplaceOutBufferLink& buf_link = outputs[i].buf_links[j] ;
			buf_link.node = 0 ;
			buf_link.channel_in = -1 ;
			DfNode * driven_node = out->GetNode();
			if (!driven_node) {
				continue ;
			}
			buf_link.node = driven_node ;
			buf_link.channel_in = out->GetIndex();
			// LogOut << "this channel is " << buf_link.channel_in << "\n" ;
		}
		if (j != size) DbgError("ReplaceNodeLinks::ctor",
            "size and links inconsistent end");
	}
}

ReplaceNodeLinks::~ReplaceNodeLinks()
{
	delete inputs ;
	if (outputs) {
		delete outputs->buf_links ;
		delete outputs ;
	}
}

ErrCode ReplaceNodeLinks::LinkNewNode(ProcessNet &Net, DfNode & new_node)
{
	// TestAlloc("ReplaceNodeLinks::LinkNewNode");
/*
 *	LogOut << "Net is " << Net.GetName() << ", node to replace is " <<
 *		node.GetName() << ", new node is " << new_node.GetName() << "\n" ;
 */
	if (new_node.GetIn() != in) {
		State.Error("the replacement has ",
			in > new_node.GetIn() ? "more" : "fewer", " input channels");
		return FatalError ;
	}
	if (new_node.GetOut() != out) {
		State.Error("the replacement has ",
			out > new_node.GetOut() ? "more": "fewer", " output channels");
		return FatalError ;
	}
	if (Net.GetTheController())
		Net.GetTheController()->EditNetwork("replacement node");
	if (State.IsError()) return FatalError ;
	if (!in) Net.remove_signal_node(node);
	if (State.IsError()) return FatalError ;
	node.RemoveAllLinks();
	if (State.IsError()) return FatalError ;
	for (int i = 0 ; i < in ; i++) {
		DfNode * the_node = inputs[i].node ;
		if (!the_node) continue ;
		if (the_node == &node) the_node = &new_node ;
/*
 *		LogOut << "linking " << the_node->GetName() <<
 *				" " << inputs[i].channel_from << " to " << i << "\n" ;
 */
		Net.Link(*the_node,inputs[i].channel_from) >>
			new_node.LinkIn(i);
		// TestAlloc("after_link");
		if (State.IsError()) return FatalError ;
	}
	for (i = 0 ; i < out ; i++) {
		// LogOut << "linking outputs from channel " << i << "\n" ;
		for (int j = 0 ; j <outputs[i].size; j++) {
			if (!outputs[i].buf_links) continue ;
			ReplaceOutBufferLink& buf_link = outputs[i].buf_links[j] ;
			DfNode * the_node = buf_link.node ;
			if (!the_node) continue ;
			if (the_node == &node) the_node = &new_node ;
/*
 *			LogOut << "Linking " << i << " to " << the_node->GetName()
 *				<< " " << buf_link.channel_in << "\n" ;
 */
			Net.Link(new_node,i) >> (*the_node).LinkIn(buf_link.channel_in);
			if (State.IsError()) return FatalError ;
		}
	}
	return OK ;
}
