/*
 *  adjust.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "adjust.h"
#include "travparm.h"

Adjustment::Adjustment(TraverseObject& obj, Command cmd, int32 Enlarge_Base,
	int32 Enlarge_Size, int New_Total, int Sequence_Index):
	Object(obj),
	TheCommand(cmd),
	EnlargeBase(Enlarge_Base),
	EnlargeSize(Enlarge_Size),
	NewTotal(New_Total),
	SequenceIndex(Sequence_Index)
{}

Adjustment::Adjustment(Adjustment& obj):
	Object(obj.GetTraverseObject()),
	EnlargeBase(obj.GetEnlargeBase()),
	EnlargeSize(obj.GetEnlargeSize()),
	NewTotal(obj.GetNewTotal()),
	SequenceIndex(obj.GetSequenceIndex()),
	PathIn(obj.GetInLink()),
	TheCommand(obj.GetCommand())
{
}

