/*
 *  tardb.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <string.h>
#include "tardb.h"
#include"cgidbg.h"

NamePairList * TargetDataBase = 0 ;

const char * NamePair::Check(const char * ref)
{
	if (!strcmp(ref,Reference)) return Value ;
	return 0 ;
}

NamePair * NamePairList::FindValue(const char * Reference)
{
	// LogOut << "NamePairList::FindValue(" << Reference << ")\n" ;
	NamePairListIterator Next(*this);
	NamePair * Pair ;
	while (Pair = Next()) {
/*
 *		LogOut << "Checking(" << Pair->Reference << ", " <<
 *			Pair->Value << ")\n" ;
 */
		if (Pair->Check(Reference)) return Pair ;
	}
	return 0 ;
}

void NamePairList::ClearAlreadyOutput()
{
	// LogOut << "NamePairList::ClearAlreadyOutput()\n" ;
	NamePairListIterator Next(*this);
	NamePair * Pair ;
	while (Pair = Next()) Pair->AlreadyOutput=0 ;
}

ErrCode NamePairList::Append(const char * A, const char *B)
{
	// LogOut << "NamePairList::Append(" << A << ", " << B << ")\n" ;
	return Append(new NamePair(A,B));
}

