/*
 *  optabs.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "portable.h"
#include "y.tab.h"

#include "optab.h"
#include "opsemant.h"

DeclarationPtr UnTheNodes ;
DeclarationPtr UnTheCmpdNodes ;
DeclarationPtr UnTheDisplays ;
DeclarationPtr UnTheSignals ;
DeclarationPtr UnTheNets ;

static struct OperandAndSemant ShiftRightNodes[] = {
	{{OperandIntEntList,&UnTheNodes},ConnectNodes},
	{{OperandEnd}}
};

static struct OperandAndSemant ShiftRightDisplays[] = {
	{{OperandIntEntList,&UnTheDisplays},ConnectNodes},
	{{OperandEnd}}
};

static struct OperandAndSemant PlusSignals[] = {
	{{OperandIntEntList,&UnTheSignals},ConnectSignalSource},
	{{OperandEnd}}
};

static struct OperandOpt ShiftRightOperands[] =
{
	{{OperandIntEntList,&UnTheNets}, ShiftRightNodes},
	{{OperandIntEntList,&UnTheNets}, ShiftRightDisplays},
	{{OperandEnd}}
};

static struct OperandOpt PlusOperands[] =
{
	{{OperandIntEntList,&UnTheNets}, PlusSignals},
	{{OperandEnd}}
};

struct ClassOp AllClassBinaryOps[] =  
{
	{SHIFT_R, ShiftRightOperands},
	{'+', PlusOperands},
	{0}
};

