#!/usr/bin/perl
#  check_prev_val.pl from ObjectProDSP 0.1
#  Copyright (C) 1994, Mountain Math Software, All rights reserved.
#  Licensed for free use and distribution under version 2 of the Gnu General
#  Public License. Please see file COPYING for details and restrictions.
#  
#  ObjectProDSP is a trademark of Mountain Math Software.
#  
# perl script to compare current and previous validation logs.

sub USAGE {
	print "Usage: perl check_prev_val.pl current previous.\n" ;
	print "Compares tests logged on the two scripts.\n" ;
	exit(1);
}

sub BAD_LINE {#0 - reason, 1 - line, 3 - file
	print stderr "Error: $_[0]\nat line $_[1] in `$_[2]'.\n" ;
	exit(1);
}

sub READ_COMPARES { # $_[0] is file handle, $_[1] is line number, $_[2] name
	while ($line = <$_[0]> ) {
		$_[1]++ ;
   		| $line =~ m/^Did / ) || last ;
        $line =~ m/^Compare_/ ) || &BAD_LINE(
			"`Compare_' missing at start of test line",$_[1],$[2]);
		@words = split (' ',$line);
		$words[1] eq "compared" || &BAD_LINE("`compared' missing",
		$words[3] eq "comparisons" || &BAD_LINE("`comparisons' missing",
			$_[1],$[2]);
		$words[4] eq "with" || &BAD_LINE("`with' missing",
			$_[1],$[2]);
		$loc_errors += $words[5] ;
		$loc_tests += $words[4] ;
		$_{$words[0]} = $words[2];
		$loc_count{$words[0]}= $words[4] ;
	}
}
		
	}
}
	

$#ARGV == 2 || &USAGE ;

open(CURR_HANDLE,$ARGV[0]) ||
	die("Cannot read current validation file `$ARGV[0]': $!");
open(PREV_HANDLE,$ARGV[1]) ||
	die("Cannot read previous validation file `$ARGV[1]': $!");

while ($line = <CURR_HANDLE>) {
	if ($line =~ m/^Doing / ) {
		# read in test performed into associative array
		while ($line = <PREV_HANDLE> ) {
			! $line =~ m/^Did / ) || last ;
			$line =~ m/
	}
}
