/*
 *  elinlist.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef ELINLIST_DOT_H
#define ELINLIST_DOT_H


class LinearList {
	long count ;
	long size ;
	long next_count ;
	const void ** objects ;
	void add_check_size();
protected:
	void add(void * obj);
	void add(void ** objs);
	const void * get(long index) const ;
	const void * next(long init_index= -1);
	long next_index() const {return next_count;}
	void replace(const void * obj);
	void insert(long after, const void * obj);
public:
	LinearList(const void ** init_list=0);
	virtual ~LinearList();
	void clear(long lim = -1); // will delete array if size > lim
	long number() const {return count;}
	void Remove(long index);
	void replace(const void * obj, long index);
};

#define __makeLinearListClassName(prefix) prefix##_LinearList
#define makeLinearListClassName(prefix) __makeLinearListClassName(prefix)

#define declareLinearList(class_name) \
class makeLinearListClassName(class_name): public LinearList { \
public: \
	makeLinearListClassName(class_name)(class_name ** objs=0): \
		LinearList((const void **)objs){} \
	void add(const class_name * obj) {LinearList::add((void *)obj);} \
	void add(const class_name **objs) {LinearList::add((void **)objs);} \
	const class_name * get(long index) const \
		{return (class_name *) LinearList::get(index);} \
	const class_name * next(long init_index= -1) \
		{return (class_name *) LinearList::next(init_index);} \
	void dump() const ; \
	void delete_all() ; \
	void insert(long index, const class_name *) ; \
	void replace(const class_name *)  ; \
	const class_name * find(const char *) const ; \
}; 


#define declareEditLinearList(class_name) \
class makeLinearListClassName(class_name): public LinearList { \
public: \
	makeLinearListClassName(class_name)(class_name ** objs=0): \
		LinearList((void **)objs){} \
	void add(class_name * obj) {LinearList::add((void *)obj);} \
	void add(class_name **objs) {LinearList::add((void **)objs);} \
	class_name * get(long index) const \
		{return (class_name *) LinearList::get(index);} \
	class_name * next(long init_index= -1) \
		{return (class_name *) LinearList::next(init_index);} \
	void dump() const ; \
	void delete_all() ; \
	void insert(long index, class_name *) ; \
	void replace(class_name *)  ; \
	class_name * find(const char *) const ; \
}; 

#define implementEditLinearList(class_name) \
	void makeLinearListClassName(class_name)::insert(long index, \
		class_name * to_insert) \
	{ \
		LinearList::insert(index, (const void *) to_insert); \
	}\
	void makeLinearListClassName(class_name)::delete_all() \
	{ \
		class_name * obj ; \
		for (long i = 0 ; i < number(); i++) { \
			obj = get(i); \
			delete obj ; \
		} \
		clear(); \
	}
	
		

class Int_LinearList {
	int * objects ;
	long count ;
	long size ;
	long next_count ;
public:
	Int_LinearList();
    virtual ~Int_LinearList();
	void add(int obj);
	int get(long index)const ;
	int  next(long init_index= -1) ;
    void clear(long lim = -1); // will delete array if size > lim
    long number() const {return count;}

	void dump() const ;
};

class String_LinearList: public LinearList {
public:
	String_LinearList(const char ** objs=0):LinearList((void **)objs){}
	void add(const char * obj){LinearList::add((void *)obj);}
	void add(const char ** objs){LinearList::add((void **)objs);}
	const char * sget(long index)const {return (char *) LinearList::get(index);}
	const char * get(long index)const {return (char *) LinearList::get(index);}
	const char * next(long init_index= -1) 
		{return (char *) LinearList::next(init_index);}
	void dump() const ;
};

#endif /* #ifdef ELINLIST_DOT_H */
