/*
 *  datfile.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef DATFILE_DOT_H
#define DATFILE_DOT_H
#include "ObjProDSP/portable.h"
#include "ObjProDSPcom/hdtypes.h"

/*
 *	IMPORTANT 		IMPORTANT 		IMPORTANT 	
 *
 * Must update help file `ionod.roff if information in this header is changed
 *
 */ 

class TimingDescription ;

#ifdef TI_C30
// Kludge because TI C complier does not handle static class members correctly

enum DataType {
	DataTypeNull=0,
	DataTypeDouble = 1,  // ArithType::ArithDouble,
	DataTypeInt16 = 2,   // ArithType::ArithInt16,
	DataTypeInt32 = 3,   // ArithType::ArithInt32,
	DataTypeFloat = 4,   // ArithType::ArithFloat,
	DataTypeUpperLim = 5 
};

#else
#include "ObjProDSP/arthtyp.h"
enum DataType {
	DataTypeNull=0,
	DataTypeDouble = ArithType::ArithDouble,
	DataTypeInt16 = ArithType::ArithInt16,
	DataTypeInt32 = ArithType::ArithInt32,
	DataTypeFloat = ArithType::ArithFloat,
	DataTypeUpperLim
};
#endif

struct NodeOutFileHeader ;

struct C30NodeOutFileHeader {
	int32 TheDataType ;
	int32 NumberChannels ;
	int32 BlockSize ;
	inline C30NodeOutFileHeader(NodeOutFileHeader& Head);
};

struct NodeOutFileHeader {
	DataType TheDataType ;
	int16 NumberChannels ;
	int32 BlockSize ;
	NodeOutFileHeader(DataType type, int16 chan, int32 blck)
		{TheDataType = type; NumberChannels = chan;
		BlockSize = blck; }
	NodeOutFileHeader()
		{TheDataType=DataTypeNull;NumberChannels=0; BlockSize=0;}
	NodeOutFileHeader(C30NodeOutFileHeader& C30) {
		TheDataType=(DataType)(C30.TheDataType) ;
		NumberChannels=C30.NumberChannels ;
		BlockSize=C30.BlockSize;
	}
};

inline C30NodeOutFileHeader::C30NodeOutFileHeader(NodeOutFileHeader& Std)
{
	TheDataType=Std.TheDataType ;
	NumberChannels=Std.NumberChannels ;
	BlockSize=Std.BlockSize;
}


const MaxBlockSize = (1024*1024) ;

extern const char * DataFilePrologue ;
	// The last five characters of this are ignored on reads.
	// This allows updated versions of the software may 
	// generate new information and store it
	// at the end of the file or wherever a packet of
	// type `FileEltsChannelHeader' is expected. The new information
	// will be ignored by the older versions of the software,
	// but the basic information can still be processed.

const char * GetNameOfDataType(DataType);
int GetSizeOfDataType(DataType) ;
class MachWord ConvertToMachWord(DataType type,void * Data, int& OverflowFlag) ;

#endif /* #ifdef DATFILE_DOT_H */
