#if 0
drealmBBS - Bulletin Board System for Linux
Copyright (C) 1994, 1995  Inge Cubitt and Peter Jones

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

The GNU General Public License should be in a file called COPYING.
#endif
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <errno.h>

#include <unistd.h>
#if defined(SVR42) || defined(LINUX_WITH_DGRAMS)
#  include <sys/socket.h>
#  include <sys/un.h>
#  if defined(SVR42)
int sendto(int s, char *msg, int len, int flags, caddr_t to, int tolen);
int socket(int domain, int type, int protocol);
#  endif
#else
#  if defined(LINUX)
#    include <fcntl.h>
#  endif
#endif

#include "drealm.h"
#include "drealmgen.h"
#include "mainfuncs.h"
#include "genfuncs.h"

#include "timerfuncs.h"

struct message {
	int signal;
};

int timer_start (char *params) {
/* MENU COMMAND */
/* Only takes minutes out of the menu */

	tnt(params);
	if (params[0] && is_num(params)) {
		return start_timer(atoi(params));
	} else {
		errorlog("No time given for the timer");
		return 0;
	}
}

int timer_stop (char *dummy) {
/* MENU COMMAND */
	timersend(1);
	return 1;
}

int timer_suspend (char *dummy) {
/* MENU COMMAND */
	timersend(2);
	return 1;
}

int timer_resume (char *dummy) {
/* MENU COMMAND */
	timersend(3);
	return 1;
}

int start_timer (int minutes) {
	pid_t pid = getpid();
	char temp[MAINLINE + 100];

#if !defined(LINUX)
	sprintf(temp,"timer %d %s %s %ld &",minutes,C.tmpdir,U.id,pid);
#else
	sprintf(temp,"timer %d %s %s %d &",minutes,C.tmpdir,U.id,pid);
#endif
	dsystem(temp);
	return 1; /* timer in the background is always true */
}

#if defined(SVR42) || defined(LINUX_WITH_DGRAMS)
void timersend(const unsigned int signal) {
	struct message msg;
	int sock_out;
	struct sockaddr_un dgram_out;

	if ((sock_out=socket(AF_UNIX, SOCK_DGRAM, 0)) < 0) {
		sprintf(G.errmsg,"Problems with timer. %s. Please consult Author for solution!",strerror(errno));
		errorlog(G.errmsg);
		printf("Problems with timer.  Please tell sysop.\n");
		return;
	}

	msg.signal = signal;

	dgram_out.sun_family = AF_UNIX;
	sprintf(dgram_out.sun_path,"%s/time.%s",C.tmpdir,U.id);

#if defined(SVR42)
	/* LINTED *//* casts to (char *) and (caddr_t) */
	if (sendto(sock_out, (char *) &msg, sizeof msg, 0,(caddr_t) &dgram_out,strlen(dgram_out.sun_path) + sizeof dgram_out.sun_family) < 0)
#else
	if (sendto(sock_out, (char *) &msg, sizeof msg, 0,(struct sockaddr *) &dgram_out,strlen(dgram_out.sun_path) + sizeof dgram_out.sun_family) < 0)
#endif
	{
		if (errno != ENOENT) {
			sprintf(G.errmsg,"Problems with timer socket. %s. Please consult Author for solution!",strerror(errno));
			errorlog(G.errmsg);
			printf("Problems with timer.  Please tell sysop.\n");
			return;
		}
	}
	close(sock_out);
}
#else
#  if defined(LINUX)
void timersend(const unsigned int signal) {
	struct message msg;
	char endpoint[108];
	int outgoing;

	sprintf(endpoint,"%s/time.%s",C.tmpdir,U.id);
	if ((outgoing=open(endpoint,O_WRONLY | O_NONBLOCK,0)) < 0) {
		if ((errno != ENOENT) && (errno != EAGAIN)) {
			sprintf(G.errmsg,"Problems with timer. %s. Please consult Author for solution!",strerror(errno));
			errorlog(G.errmsg);
			printf("Problems with timer.  Please tell sysop.\n");
		} else {
			sprintf(G.errmsg,"Got ``%s'' trying to open '%s'.  Is timer running?",strerror(errno),endpoint);
			errorlog(G.errmsg);
		}
		return;
	}

	msg.signal = signal;

	if (write(outgoing,&msg, sizeof msg) < sizeof msg) {
		sprintf(G.errmsg,"Problems with timer. %s. Please consult Author for solution!",strerror(errno));
		errorlog(G.errmsg);
		printf("Problems with timer.  Please tell sysop.\n");
		return;
	}
	close(outgoing);
}
#  else
/* ARGSUSED0 */
void timersend(const unsigned int signal) {
#error This system has nothing we can use as a socket
	(void)printf("Timer not supported on this system.\n");
}
#  endif
#endif
