#if 0
drealmBBS - Bulletin Board System for Linux
Copyright (C) 1994, 1995  Inge Cubitt and Peter Jones

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

The GNU General Public License should be in a file called COPYING.
#endif
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#include "display.h"

struct _area_header {
	char *flag;	/* '#' normally; 'A' for ANSI; 'V' for voting */
	char *this;	/* Message number for display */
	char *dname;	/* Day name */
	char *mname;	/* Month name */
	char *dom;	/* Day of month */
	char *time;	/* Time of day */
	char *tzname;	/* Timezone */
	char *year;	/* Year */
	char *from;	/* "from" */
	char *fromname;	/* name of sender */
	char *narr;	/* "BASE-MESSAGE", "reply-to", etc */
	char *hash;	/* "-" or "#" */
	char *parent;	/* Message this is a reply to */
	char *by;	/* "-" or "by" */
	char *byname;	/* Name of sender of parent */
	char *base;	/* Message number of base of thread */
	char *next;	/* Next in thread (or "-" if last in thread) */
	char *prev;	/* Previous in thread (or last in thread if base) */
	char *replies;	/* Space-separated numbers of replies */
};

static struct _area_header area_header;

static void print_area_message(char *areasdir, char *area, char *msgno);
static int parse_area_header(char *filename);
static void print_area_header(void);
static void print_area_body(char *filename);

int main(int argc, char *argv[]) {
/* LENGTHS CHECKED */
	if ((argc < 4) || (argc > 5)) {
#if defined(DEVEL)
		(void)fprintf(stderr,"Syntax: %s areasdir area msgno\n",argv[0]);
#endif
		return 1;
	}
	print_area_message(argv[1],argv[2],argv[3]);
	if (argc == 5) page_file(argv[4]);
	return 0;
}

static void print_area_message(char *areasdir, char *area, char *msgno) {
/* LENGTHS CHECKED */
	char *filename;

	filename = (char *)malloc(strlen(areasdir) + strlen(area) + strlen(msgno) + 8 /* fixed bit */);

	get_LW(1);

	TOT_LINES = 0;
	/*if (!LINES)*/ {
		(void)printf("\nArea: %s\n", area);
		TOT_LINES += 2;
	}
	(void)sprintf(filename,"%s/%s/hdr.%s",areasdir,area,msgno);
	if (parse_area_header(filename)) print_area_header();
	else {
		(void)printf("Could not read %s\n",filename);
		TOT_LINES += 1;
	}
	(void)sprintf(filename,"%s/%s/msg.%s",areasdir,area,msgno);
	print_area_body(filename);
	if (area_header.flag[0] == 'V') {
		(void)sprintf(filename,"%s/%s/vote.%s",areasdir,area,msgno);
		page_file(filename);
	}
	free(filename);
}

static int parse_area_header(char *filename) {
/* LENGTHS CHECKED */
	static char header[1024];
	char *p, *q;
	FILE *HDR = fopen(filename,"r");


	if (!HDR) {
#if defined(DEVEL)
		perror("fopen header");
#endif
		return 0;
	}

	fread(header,sizeof (char),1023,HDR);
	if (ferror(HDR)) {
#if defined(DEVEL)
		perror("fread header");
#endif
		return 0;
	}
	header[1023] = 0;
	p = header;

	for(q = p; !isspace(*p); p++); area_header.flag = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.this = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.dname = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.mname = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.dom = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.time = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.tzname = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.year = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.from = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.fromname = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.narr = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.hash = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.parent = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.by = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.byname = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.base = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.next = q;
	for(;isspace(*p); *p++='\0');
	for(q = p; !isspace(*p); p++); area_header.prev = q;
	for(;isspace(*p); *p++='\0');

	area_header.replies = p;

	return 1;
}

static void print_area_header(void) {
/* LENGTHS CHECKED */
	struct _area_header *h = &area_header;
	(void)printf("%s %s %s %s %s %s %s %s %s %s %s %s base %s %s\n",
		h->this, h->dname, h->mname, h->dom, h->time, h->year,
		h->from, h->fromname, h->narr, h->parent, h->by,
		h->byname, h->base, strcmp(h->next,"-") ? ">" : "");
	if (h->replies[0]) (void)printf("Replies: %s\n", h->replies);
	else (void)printf("No replies\n");
	TOT_LINES += 2;
}

static void print_area_body(char *filename) {
/* LENGTHS CHECKED */
	FILE *BODY;
	char buffer[256];

	if (!(BODY=fopen(filename,"r"))) {
#if defined(DEVEL)
		perror("fopen body");
#endif
		return;
	}
	/* Subject: line */
	(void)fgets(buffer,256,BODY);
	(void)printf(buffer);
	TOT_LINES += 1;
	/* Blank line after subject */
	(void)fgets(buffer,256,BODY);
	(void)printf(buffer);
	TOT_LINES += 1;
	if (LINES && (area_header.flag[0] == 'A')) {
		(void)printf("Press [ENTER] to continue: ");
		(void)fgets(buffer,256,stdin);
		TOT_LINES = 0;
	}
	if (LINES && (area_header.flag[0] == 'A')) {
		int i=LINES;
		LINES=0;
		(void)pager(BODY,-1);	/* no pagination */
		LINES=i;
	} else (void)pager(BODY,1);	/* always paginate */
	if (LINES && (area_header.flag[0] == 'A')) {
		(void)printf("%c[%d;1H%c[K%c[0;10mPress [ENTER] to continue: ",27,LINES,27,27);
		(void)fgets(buffer,256,stdin);
		TOT_LINES = 0;
	}
}
