#!/bin/sh
#
# usage: use-unproto [-cpp="cpp-cmd"] cc -Ddefs -Idirs etc. etc. -c source.c
#
# lazy: this'll only handle files that end in .c or .h.

usage() {
    echo "usage: use-unproto {cc command}"
    exit 1
}

del_tmp() {
    rm -f tmp_unproto.c tmp_unproto.o
    exit 1
}

[ $# = 0 ] && usage

cflags=
sourcefiles=

CC=cc
CPP=UNSET

while [ $# != 0 ] ; do
    case "$1" in
    *cc )
	CC=$1
	if test "$CPP" = unset ; then
	    CPP="$CC -E"
	fi
	;;
    -cpp=* )
	CPP=`echo $1 | sed 's,^.*=,,'`
	;;
    -c )
	;;
    *.c )
	sourcefiles="$sourcefiles $1"
	objfile=`echo $1 | sed 's,^.*/\([^/]*\)\.c$,\1.o,'`
	;;
    *.h )
	sourcefiles="$sourcefiles $1"
	;;
    * )
	cflags="$cflags $1"
	;;
    esac
    shift
done

[ "$cflags" = "" ] && usage
[ "$sourcefiles" = "" ] && usage

trap del_tmp 2 3

# echo "$CPP $cflags $sourcefiles | unproto > tmp_unproto.c"
$CPP $cflags $sourcefiles | unproto > tmp_unproto.c

# echo "$CC $cflags -c tmp_unproto.c"
$CC $cflags -c tmp_unproto.c

# echo "mv tmp_unproto.o $objfile"
mv tmp_unproto.o $objfile

rm -f tmp_unproto.c
