#ifndef PLP_PORTABLE_H
#define PLP_PORTABLE_H

#include "config.h"

/* porting note: if you port PLP and you get some errors
 * caused by autoconf guessing the wrong set of functions/headers/structs,
 * change the bit for your system in the ARGH section below.
 */

/*************************************************************************
 * ARGH: some things that "configure" can't get right.
 */
/*************************************************************************/

/* whoever put that ANSI stuff in derserves to be shot! (mj) */
#ifdef apollo
#undef __STDC__
#define CONFLICTING_PROTOS 
#endif

#ifdef IS_T35
#undef HAVE_UNISTD_H
#endif

/*************************************************************************/
#ifdef ultrix
#define IS_ULTRIX
#undef HAVE_SETEUID
#undef HAVE_SETRESUID
#ifndef HAVE_SETREUID
#define HAVE_SETREUID	/* use setreuid(). */
#endif
#endif

/*************************************************************************/
#if defined(sun) && !defined(__svr4__) && !defined(SVR4) && !defined(__SVR4)
#define IS_SUNOS4
/* using lockf() or fcntl(..,F_SETLK,..) does not work on
 * character devices in SunOS 4.1.?. (mj)
 */
#define LOCK_DEVS_WITH_FLOCK

#undef HAVE_SETEUID
#undef HAVE_SETRESUID
/* default is to use setreuid(). */

#if 0
#undef USE_TERMIO		/* also doesn't work as expected */
#define USE_SGTTY
#endif
#endif

/*************************************************************************/
#if defined(NeXT)
#define IS_NEXT

#define __STRICT_BSD__

#undef HAVE_FCNTL
#undef HAVE_LOCKF

#undef HAVE_SETEUID
#undef HAVE_SETRESUID
/* default is to use setreuid(). */
#endif

/*************************************************************************/
#if defined(__sgi) && defined(_SYSTYPE_SVR4)
#define IS_IRIX5
#endif

/*************************************************************************/
#if defined(__sgi) && defined(_SYSTYPE_SYSV)
#define IS_IRIX4
#endif

/*************************************************************************/
#if defined(__linux__) || defined (__linux) || defined (LINUX)
#define IS_LINUX
#undef HAVE_SETEUID		/* thanks to Stefano Ianigro */
#undef USE_TERMIO
#define USE_TERMIOS 1
#endif

/*************************************************************************/
#if defined(__hpux)
#define IS_HPUX

#undef USE_SGTTY
#ifndef USE_TERMIO
#define USE_TERMIO
#endif
#endif
  
/*************************************************************************/

#if defined(__convex__) /* Convex OS 11.0 - from w_stef */
#define IS_CONVEX
#define LPASS8 (L004000>>16)
#undef HAVE_SETEUID
#endif

/*************************************************************************/

#ifdef _AUX_SOURCE
#define IS_AUX
#define _POSIX_SOURCE

#undef HAVE_SETEUID
#undef HAVE_SETRESUID
/* default is to use setreuid(). */

#undef USE_TERMIO
#define USE_TERMIOS

#undef SETPROCTITLE
#endif


/*************************************************************************/
/* we also need some way of spotting IS_DATAGEN (Data Generals),
 * and IS_SEQUENT (Sequent machines). Any suggestions?
 */

/*************************************************************************
 * END OF ARGH SECTION; next: overrides from the Makefile.
 */

#ifdef MAKE_STATFS
#undef USE_STATVFS
#undef USE_STATFS
#undef USE_ULTRIX_STATFS
#undef USE_STATFS_NO_BAVAIL
#ifdef MAKE_USE_STATFS
#define USE_STATFS
#endif
#ifdef MAKE_USE_STATVFS
#define USE_STATVFS
#endif
#endif

#ifdef MAKE_STTY
#undef USE_TERMIO
#undef USE_TERMIOS
#undef USE_SGTTY
#ifdef MAKE_USE_SGTTY
#define USE_SGTTY
#endif
#ifdef MAKE_USE_TERMIO
#define USE_TERMIO
#endif
#ifdef MAKE_USE_TERMIOS
#define USE_TERMIOS
#endif
#endif

#ifdef MAKE_SUID
#undef USE_SETEUID
#undef USE_SETREUID
#undef USE_SETRESUID
#ifdef MAKE_USE_SETEUID
#define USE_SETEUID
#endif
#ifdef MAKE_USE_SETREUID
/* the default is to use setreuid(). */
#else
#define USE_SETRESUID
#endif
#endif

#if defined(__svr4__) && !defined(SVR4)
#define SVR4 __svr4__
#endif

#include <sys/types.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <stdio.h>
#include <sys/param.h>

/* yuck -- this is a nightmare! half-baked-ANSI systems are poxy */
#ifdef STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#endif

#ifndef HAVE_STRCHR
# define strchr			index
# define strrchr		rindex
/*char *index (), *rindex (); */
#endif

#ifndef HAVE_BCOPY
# define bcopy(s, d, n)		(memcpy ((d), (s), (n)))
# define bcmp(s1, s2, n)	(memcmp ((s1), (s2), (n)))
# define bzero(s, n)		(memset ((s), 0, (n)))
#endif

#if HAVE_DIRENT_H
# include <dirent.h>
# define NLENGTH(dirent) strlen((dirent)->d_name)
#else
# define dirent direct
# define NLENGTH(dirent) (dirent)->d_namlen
# if HAVE_SYS_NDIR_H
#  include <sys/ndir.h>
# endif
# if HAVE_SYS_DIR_H
#  include <sys/dir.h>
# endif
# if HAVE_NDIR_H
#  include <ndir.h>
# endif
#endif

typedef struct dirent plp_dir_t;

#ifdef HAVE_COMPAT_H
#include <compat.h>
#endif
#ifdef HAVE_MALLOC_H
#include <malloc.h>
#else /* risky, risky... (mj) */
char *malloc(size_t);
void free(void *);
#endif

#ifndef HAVE_ERRNO_DECL
extern int errno;
#endif

#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#ifdef HAVE_SYS_FILE_H
#include <sys/file.h>
#endif
#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif

#ifdef HAVE_SYS_FCNTL_H
#include <sys/fcntl.h>
#else
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif
#endif

#if defined(HAVE_FCNTL) && defined(FD_SETLK)
#define HAVE_FCNTL_LOCK
#endif

#if defined(HAVE_LOCKF) && ! defined(F_LOCK)
#undef HAVE_LOCKF
#endif

#if defined(HAVE_FLOCK) && ! defined(LOCK_EX)
#undef HAVE_FLOCK
#endif

#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <pwd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <errno.h>
#include <grp.h>
#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif

/* 4.2 BSD systems */
#ifndef S_IRUSR
#define S_IRUSR S_IREAD
#define S_IWUSR S_IWRITE
#define S_IXUSR S_IEXEC
#define S_IXGRP (S_IEXEC >> 3)
#define S_IXOTH (S_IEXEC >> 6)
#endif

#ifndef S_ISLNK
#define S_ISLNK(mode) (((mode) & S_IFLNK) == S_IFLNK)
#endif

/* 4.2 BSD systems */
#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif

#if 0
#ifndef HAVE_STRCHR
#define strchr(x,y)	((char *) index(x,y))
#define strrchr(x,y)	((char *) rindex(x,y))
#endif
#endif

#ifndef HAVE_KILLPG
#define killpg(pg,sig)	((int) kill ((pid_t) - (pg), sig))
#endif

/***********************************************************************
 * wait() stuff: most recent systems support a compatability version
 * of "union wait", but it's not as fully-featured as the recent stuff
 * that uses an "int *". However, we want to keep support for the
 * older BSD systems as much as possible, so it's still supported;
 * however, if waitpid() exists, we're POSIX.1 compliant, and we should
 * not use "union wait". (hack hack hack)
 */

#ifdef HAVE_WAITPID
#undef HAVE_UNION_WAIT
#define plp_wait_kid(status,wflags) ((pid_t) waitpid ((pid_t) -1, status, wflags))
#else
/* HAVE_UNION_WAIT will be def'd by configure if it's in <sys/wait.h>. */
#define plp_wait_kid(status,wflags) ((pid_t) wait3 (status, wflags, (struct rusage *) NULL))
#endif

#ifdef HAVE_UNION_WAIT
typedef union wait		plp_status_t;
/*
 * with some BSDish systems, there are already #defines for this,
 * so we should use them if they're there.
 */
#ifndef WCOREDUMP
#define WCOREDUMP(x)	((x).w_coredump)
#endif
#ifndef WEXITSTATUS
#define WEXITSTATUS(x)	((x).w_retcode)
#endif
#ifndef WTERMSIG
#define WTERMSIG(x)	((x).w_termsig)
#endif
#ifndef WIFSTOPPED
#define WIFSTOPPED(x)	((x).w_stopval == WSTOPPED)
#endif
#ifndef WIFEXITED
#define WIFEXITED(x)	((x).w_stopval == WEXITED)
#endif

#else
typedef int			plp_status_t;
/* The POSIX defaults for these macros. (this is cheating!) */
#ifndef WTERMSIG
#define WTERMSIG(x)	((x) & 0x7f)
#endif
#ifndef WCOREDUMP
#define WCOREDUMP(x)	((x) & 0x80)
#endif
#ifndef WEXITSTATUS
#define WEXITSTATUS(x)	(((x) >> 8) & 0xff)
#endif
#ifndef WIFSIGNALED
#define WIFSIGNALED(x)	(WTERMSIG (x) != 0)
#endif
#ifndef WIFEXITED
#define WIFEXITED(x)	(WTERMSIG (x) == 0)
#endif
#endif	/* HAVE_UNION_WAIT */

#define PLP_WEXITSTATUS(status)	(WEXITSTATUS((status)))
#define PLP_WTERMSIG(status)	(WTERMSIG((status)))
#define PLP_WIFSTOPPED(status)	(WIFSTOPPED((status)))
#define PLP_WIFEXITED(status)	(WIFEXITED((status)))
#define PLP_WCOREDUMP(status)	(WCOREDUMP((status)))

/***********************************************************************
 * SVR4: SIGCHLD is really SIGCLD; #define it here.
 * PLP lpd _does_ handle the compatibility semantics properly
 * (Advanced UNIX Programming p. 281).
 */
#if !defined(SIGCHLD) && defined(SIGCLD)
#define SIGCHLD			SIGCLD
#endif

#if defined(HAVE_SIGACTION) && !defined(SIG_ERR)
#undef HAVE_SIGACTION
#endif

typedef RETSIGTYPE plp_signal_t;

#ifdef HAVE_SETSID
#define plp_setsid()		(setsid())
#else
#define plp_setsid()		(setpgrp(getpid(), 0))
#endif

#ifndef HAVE_GETDTABLESIZE
# ifdef NOFILE
#  define getdtablesize()	NOFILE
# else
#  ifdef NOFILES_MAX
#   define getdtablesize()	NOFILES_MAX
#  endif
# endif
#endif

#ifndef HAVE_UNISTD_H
extern int dup2 ();
extern int execve ();
#ifdef HAVE__EXIT
extern void _exit ();
#endif
#if 0 /* WHERE to declare them ??? (mj) */
extern int geteuid (), getegid ();
#endif
extern int setgid (), getgid ();
#endif

#ifdef HAVE_ASSERT_H
#include <assert.h>
#else
#ifdef HAVE_ASSERT
extern void assert();
#else
#define	assert(x) ((void) 0)
#endif
#endif

#ifndef HAVE_STRDUP
#ifdef __STDC__
char *strdup(char*);
#else
char *strdup();
#endif
#endif

/***********************************************************************
 * for all c compilers that do not know about the keyword 'inline':
 * define inline to nothing. (configure doesn't handle this
 * properly) :(
 */
#ifndef HAVE_INLINE
#undef inline
#define inline /**/
#endif

/* this may need to be changed when IP:ng comes out */
#define IP_ADDRESS_LEN  4               /* in bytes */

#ifndef IPPORT_RESERVED
#define IPPORT_RESERVED 1024
#endif

#endif	/* PLP_PORTABLE_H */
