/*************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 * version 3.3.0 Justin Mason July 1994
 *************************************************************************
 * MODULE: lp.h
 * Includes and definitions for all programs
 *************************************************************************/

#ifndef PLP_LP_H
#define PLP_LP_H

#include "portable.h"

/* it's tricky declaring protos for funcs with args; const may or may
 * not be used by the system include files, causing the compile to barf
 * either way. I've tried to avoid prototyping anything more than
 * the return value.
 */
char *getenv (), *ctime (), *strdup(), *strchr(), *strrchr(), *strtok();
extern pid_t getpid (void), getppid (void), fork (void);
extern uid_t getuid (void), geteuid (void);
extern void exit();
extern double atof();
extern int atoi();
extern long int atol();
extern int isatty();
extern struct passwd *getpwnam ();

/*************************************************************************
 * PRINTCAP entries and associated variables.
 * Each printcap entry has a corresponding variable; for example
 * ":af=accnt:"
 *   -> AF = "accnt";
 *************************************************************************/
extern int AB;			/* Always have a banner flag, ignore lpr -h option */
extern char *AF;		/* accounting file */
extern int AR;			/* remote printer accounting */
extern char *BP;		/* banner printer filter */
extern int BK;			/* Berkeley compatible remote and local */
extern int BR;			/* baud rate if lp is a tty */
extern int CL;			/* close device between jobs */
extern char *CM;		/* status line comment */
extern int CO;			/* cost of printing in dollars */
extern int DB;			/* Set debug level for queue handler */
extern char *EP;		/* end printer filter */
extern int EU;			/* Edinburgh University control file format */
extern int FD;			/* No forwarding, accept only from original site */
extern int FO;			/* print a form feed when device is opened */
extern int FC;			/* flags to clear if lp is a tty */
extern char *FF;		/* form feed string */
extern int FJ;			/* send control file  first to remote site */
extern int FQ;			/* form feed on quitting */
extern int FS;			/* flags to set if lp is a tty */
extern char *FX;		/* allowable formats */
extern char *LD;		/* leader string on opening */
extern char *LF;		/* log file for error messages */
extern int LA;			/* local printer accounting (by PLP) */
extern int LH;			/* use long host name */
extern char *LI;		/* file size limit */
extern char *LO;		/* lock file name */
extern char *LN;		/* group allowed to use links */
extern char *LP;		/* line printer device name */
extern int MC;			/* maximum number of copies allowed */
extern char *MI;		/* min free space to leave in spool dir */
extern int ML;			/* min legal chars for printable */
extern char *MS;		/* new stty options - as per sun */
extern int MX;			/* maximum number of blocks to copy */
extern int NW;			/* Networked file system, do not make copies */
extern int PL;			/* page length */
extern int PO;			/* remote port to connect to */
extern char *PR;		/* pr program name name */
extern char *PS;		/* printer status file name */
extern int PW;			/* page width */
extern int PX;			/* page width in pixels */
extern int PY;			/* page length in pixels */
extern char *QH;		/* queue handler */
extern char *RG;		/* restrict use to group */
extern char *RM;		/* remote machine name */
extern char *RP;		/* remote printer name */
extern int RT;			/* max retries */
extern int RW;			/* open LP for reading and writing */
extern int SB;			/* short banner instead of normal header */
extern int SC;			/* suppress multiple copies */
extern char *SD;		/* spool directory */
extern int SF;			/* suppress FF on each print job */
extern int SH;			/* suppress header page */
extern char *SS;		/* name of queue that the server serves  */
extern char *ST;		/* status file name */
extern char *SV;		/* names of servers */
extern char *TR;		/* trailer string to be output when Q empties */
extern char *TY;		/* terminal characteristics, stty options */
extern int XC;			/* flags to clear for local mode */
extern int XS;			/* flags to set for local mode */
extern char *XT;		/* format checked for text only */
extern char *XU;		/* restrict use to users whose names are in file */

/*
 * Filter_name[] is an array of filter names, indexed by the first letter of the printcap
 * tag. For example: ":if=/usr/lib/iffilter -n -a:" -> Filter_name['i'-'a'] =
 * "/usr/lib/iffilter -n -a";
 */
extern char *Filter_name[26];
#define	IF	(Filter_name['i'-'a'])
#define	OF	(Filter_name['o'-'a'])
/*
 * Prefilter_name[] is similar to Filter_name[], but for prefilter entries.
 */
extern char *Prefilter_name[26];

/*
 * this is much smaller than MAXHOSTNAMELEN, but it's needed -- plp_queue can only take
 * params <=80 chars in length, and that includes the submitting hostname.
 */
#define HOSTLEN		64
#define SHORTHOSTLEN	64

/**********************************************************************
 * Globally accessed variables and routines
 **********************************************************************/
extern char *Name;		/* program name */
extern char *Printer;		/* printer name */
extern char *Person;		/* user name */
extern char *Newjobnum;         /* A number for a command */
extern int mistake;             /* var for switching */
extern char ShortHost[HOSTLEN];	/* Host machine name */
extern char Host[HOSTLEN];	/* Host machine name (fully-qualified) */
extern char *Architecture;	/* Host machine architecture */
extern char *From;		/* client's machine name */
extern char *FQDN;		/* client's machine name (full) */
extern int Debug;		/* Debugging level */
extern int Echo_on_stdout;	/* stderr output on stdout as well */
extern char *First_name;	/* first name in printcap entry */
extern char *All_names;		/* all names in printcap entry */
extern FILE *Lfd;		/* lock file */
extern int Optind, Opterr;	/* option index, error message suppression */
extern char *Optarg;		/* option value */
extern char *Opt_flag;		/* option staring flags */
extern char *Lpdlogf, *Masterlock;
extern int Lpr_port_num;	/* port number to connect to */
extern int Maxportno;		/* = MAXPORTNO; */
extern int Minportno;		/* = MINPORTNO; */
extern char Last_errormsg[];	/* last errormessage */
extern int Request;		/* current lpd request code */
extern int Print_fd;		/* output printer file */
extern int Short_format;	/* short status format */
extern int Is_root;		/* is this the root user? */
extern int Is_local;		/* doing this locally or remotely? */
extern struct stat LO_statb;	/* used to stat lockfile */
extern int DaemonUID;		/* daemon UID */
extern int DaemonGID;		/* daemon GID */
extern int Errorcode;		/* exit() value on fatal termination */

extern char *estrcp (char *, char *, char *);
extern char *Time_str (void);
extern char *Setup_filter (int, char *);
extern int Getopt (int, char *[], char *);
extern char *Decode_status (plp_status_t *);
extern int Checkperm (char *, char *, char *, int *, int *, int);

/* if in doubt -- use a typedef ! (mj) */
typedef plp_signal_t (*plp_sigfunc_t)(int) ;
extern  plp_sigfunc_t plp_signal (int, plp_sigfunc_t);


/* varargs declarations: */

#if defined(HAVE_STDARG_H) && defined(__STDC__) 
/*
 * one never knows, old Domain/OS cc 6.7 sets __STDC__ but hasn't always
 * stdarg.h, so we'd better check for this, too! (mj)
 */
#include <stdarg.h>
#define HAVE_STDARGS    /* let's hope that works everywhere (mj) */
#define VA_LOCAL_DECL   va_list ap;
#define VA_START(f)     va_start(ap, f)
#define VA_SHIFT(v,t)	;	/* no-op for ANSI */
#define VA_END          va_end(ap)
#else

#include <varargs.h>
#undef HAVE_STDARGS
#define VA_LOCAL_DECL   va_list ap;
#define VA_START(f)     va_start(ap)		/* f is ignored! */
#define VA_SHIFT(v,t)	v = va_arg(ap,t)
#define VA_END		va_end(ap)
#endif

/*******************************************************************
 *  struct plp_queue
 *    used to record entries in the spool directory for printing
 *    and status reporting.
 *  NOTE: control and data file names in spool directory have the form
 *  c f <priority> <job number> <Hostname>  <terminating 0>
 *  d f <seq>      <job number> <Hostname>  <terminating 0>
 *  1 1 1               3        HOSTLEN        1
 * eg: dfA001attila.cs.umn.edu         (attila the SUN, of course)
 * eg: cfZ001attila.cs.umn.edu         (attila the SUN, of course)
 *******************************************************************/
#define CFNAMELEN (sizeof(Host)+8)	/* control or data file name length */
/*
 * fields in the name
 */
#define STARTPR	2		/* df[] */
#define STARTID	3		/* dfX[] */
#define IDLEN	3		/* dfX[NNN] */
#define	STARTFR	6		/* dfXNNN[] */
#define MAXPARMLEN	256

struct plp_queue {
    char q_name[CFNAMELEN + 1];	/* name of the control file */
    time_t q_time;		/* spooled at time */
    unsigned long q_time_hires;	/* spooled at time (hi-res portion) */
    time_t q_unsp;		/* unspool at time */
    int q_priority;		/* priority */
    long q_size;		/* size of the data files */
    char q_user[32];		/* user name */
    int q_num;			/* job number */
    char q_data[MAXPARMLEN + 1];/* data files name */
    int q_daemon;		/* daemon for this entry */
    char *q_server;		/* server for this entry */
    char *q_options;		/* options - from J line */
    int q_held;			/* non zero if job held */
};
#define	q_from	q_name[STARTFR]

extern int hostcmp (char *, char *);	/* compare hostnames */
extern void Startserver (void);		/* start a printer server */
extern inline void printstatus (void);	/* report printer status */

extern void Remote_status (void);	/* get status from remote host */
extern void Remote_remove (void);	/* remove job from remote host */
extern void Remote_control (char *, char *); /* control functions on remote host */
extern int Remote_start (void);		/* start remote queue */

extern int valid_forms (char *, char *); /* check if form is valid */
extern char *possible_options (void);	/* list of possible forms */
extern char *current_options (void);	/* current forms options */
extern long current_limit (void);
extern char *Sigstr (int);

extern plp_signal_t cleanup (int);	/* cleanup children and files */
extern plp_signal_t Reapchild (int);

extern int Link_port_num (void); /* port number for link */
extern void Link_get (void);	/* copies info from link to stdout */
extern int Link_ack (int);	/* get acknowledgement from link */
extern int Link_copy (FILE *, long, char *); /* copy file across link */
extern int Link_confirm (void);	/* get confirmation from link */
extern int Link_send (char *);	/* send info across link */
extern int Link_line (int, char *); /* open link and send info across */
extern void Link_close (void);	/* close link */
extern int Link_open (int);	/* open link */

extern int Print_close (void);	/* close these things */
extern int Print_ready (void);	/* is printer ready? */
extern int Print_string (char *); /* print string through a filter */
extern int Print_banner (void);	/* print banner routine */
extern int Print_copy (int);	/* copy file through printer */
extern int Print_filter (int, char *, int); /* spawn process to do printing */
extern void Print_open (void);	/* open printer */
extern void Do_stty (int);
extern int do_devlock (int, char *, int);

extern int Job_match (char *, char *); /* match host and filename */
extern int Add_name (char *);	/* adds filename to sorted list */
extern int Find_name (char *);	/* look for job in list */
extern void sendmail (struct plp_queue *, int);
extern void Std_environ (int, char **, char **); /* set up environment */
extern void Setuplog (char *, int); /* set up log file */
extern void servicereq (void);	/* service a request from socket */
extern void rm_recfiles (void);	/* remove received files */
extern void Startprinter (void); /* start printer daemon */
extern int getport (char *, int);
extern int banner (int);	/* print banner */
extern void Rename_cf (char *);	/* rename temp file to control file */
extern int bpread (int fd, char *buf, int size); /* bomb-proof read */
extern void splitline (char *);	/* split line into Parms */
extern void Get_Printer (int);	/* get printer name */
extern int Control_ops (void);	/* perform control operation */
extern int interpret_job (char *, char *, char *, char *, char *, char *, char *);
extern struct plp_queue *Jobentry;	/* current job entry in queue */
extern struct plp_queue *Queue;	/* Getq generates an array of jobs */
extern int Jobcount;		/* and returns the number of jobs  */
extern int Rec_cnt;		/* number of files in a job */

extern int Getq (void);		/* find queue entries */
extern void Remove_job (FILE *, struct plp_queue *); /* remove job */
extern int Match_entry (struct plp_queue *); /* check user name and job number */

/********************************************************************
 * File Permissions
 ********************************************************************/

#define LFMODE      0644	/* log file permissions */
#define FILMOD      0600	/* spooling directory file permission */

/*
 * Queue Control is done by using the permissions of the lock file for the queue.  The
 * following permissions are used: Disable Printing: owner execute or 0100 Disable
 * Queing:	group execute or 0010 Queue handler active (antique) 0001
 */
#define	DISABLE_PRINT	(0100)
#define	ENABLE_PRINT	(0777 & ~ DISABLE_PRINT)
#define	DISABLE_QUEUE	(0010)
#define	ENABLE_QUEUE	(0777 & ~ DISABLE_QUEUE)
#define	FORCE_REQUE	(0001)
#define	CLEAR_REQUE	(0777 & ~ FORCE_REQUE)

/*
 * syslog(8) message priorities.  These are defined by the values of global variables.
 * The variables are initialized either with values in the <syslog.h> include file,  or
 * by a set of default values according to the NOSYSLOG option in the Makefile.
 */
extern int XLOG_ERR;		/* 4 synonym of LOG_ERROR */
extern int XLOG_CRIT;		/* 5	critical information */
extern int XLOG_WARNING;	/* 6	warning */
extern int XLOG_NOTICE;		/* 7	important information */
extern int XLOG_INFO;		/* 8	informational message */
extern int XLOG_DEBUG;		/* 9	Debug level info */

/*******************************************************************
 * Printcap Data Structures
 * The printcap file information is extracted using a single pass of
 * the printcap database.  As each entry is found,  it is looked up
 * in a table which has the entry tag,  the type of entry,
 * a default value,  and the variable used to hold the value.
 *
 * The table is sorted alphabetically by the tag values and the update
 * routines use a modified binary search.  The time taken to read the
 * printcap entry is proportional to
 * K  log( M ), where K is the length of the printcap file and M is
 * the number of printcap variables.  Note that this appears to be
 * a much simpler and easier way to implement printcap information
 * extraction.  The "initialization" of the entire set of variables
 * is extremely fast,  apparently taking about the same time  as reading
 * two variables using the original "termcap" code.
 *******************************************************************/
typedef struct pc_entry {
    char pc_name[3];		/* two character name, and the last char */
    int kind;			/* the kind of entry */
#define PC_NUM		0	/* integer */
#define PC_FLAG		1	/* integer */
#define PC_STRING	2	/* string */
    int idefault;		/* this is the default integer or flag value */
    char *sdefault;		/* this is the default integer or flag value */
    /*
     * the variable is assumed to be a pointer to char; this is cast to pointer to int if
     * neccessary.
     */
    char **var;
}        PC_ENTRY;

/*
 * Routines to look up printer names and printcap entries char ** All_printers():  reads
 * the printcap database and extracts the names of all the printer entries. char
 * *First_printer(): gets name of first printer Get_pc_entry(): given name of a printer
 * and an array  of PC_ENTRIES, it finds the printcap entry and extracts all the
 * information for the variables listed in the array. Set_pc_entry(): same functionality,
 * does not initialize variables.
 */
#define PRNAMELEN	32	/* Maximum of 32 characters for each printer name */
#define MAXPCNAMES	100	/* Maximum of 100 printers */

#include "library/printcap.h"

/*
 * All_pc_vars[]: all printcap variables, and is used by lpr and lpd; Status_pc_vars[]: a
 * short set needed by lpq, lprm, and lpc. Server_pc_vars[]: a few needed by servers only
 */
extern PC_ENTRY All_pc_vars[ /* All_pc_len */ ];
extern int All_pc_len;
extern PC_ENTRY Status_pc_vars[ /* Status_pc_len */ ];
extern int Status_pc_len;
extern PC_ENTRY Server_pc_vars[ /* Server_pc_len */ ];
extern int Server_pc_len;

/***********************************************************************
 * File Locking Support:
 * see lockfile.c for details.
 ***********************************************************************/

extern FILE *Readlockfile (char *, pid_t *, char *, int, struct stat *);
extern FILE *Getlockfile (char *, pid_t *, char *, int, struct stat *);
extern pid_t Checklockfile (char *, pid_t *, char *, int, struct stat *);

extern void Setlockfile (char *, FILE *, pid_t, char *); /* set a lock on printer */
extern void Closelockfile (char *, FILE *); /* truncate & close lock file */

extern FILE *Lockcf (char *);	 /* lock a control file */
extern FILE *Unlockcf (char *);	 /* unlock a control file */
extern int Exlockcf (char *);	 /* create and lock a control file (exclusively) */
extern int NonExlockcf (char *); /* create and lock a control file (non-ex) */

extern FILE *fopen_daemon (char *, char *); /* open a file as daemon */
extern int open_daemon (char *, int, int);  /* open a file as daemon */
extern int chmod_daemon (char *, int);	    /* change file modes */
extern int unlink_daemon (char *);	    /* delete a file */
extern int chown_daemon (char *);	    /* chown a file/daemon to daemon */
extern int mkdir_daemon (char *, int);	    /* make a dir */

/***********************************************************************
 * Parameter List Support
 * struct parm parmlist[]
 *  is used when parsing a command received from a remote Host
 * It is also used by lpr to determine the command file, and to keep
 * track of the file/datafile name correspondence.
 ***********************************************************************/

struct parm {
    char *str;			/* string parameter */
    int num;			/* number parameter */
    char filename[CFNAMELEN + 1];	/* file name for parameter */
    long size;			/* size of file */
};
extern struct parm *Parms;	/* array of parmaters */
extern int Parmcount;		/* number of parameters */
extern int ParmSz;		/* size of the Parm array (in struct parms) */

extern void Shift_parms (int);	/* shift Parms array */
extern void allocParmsIfNeeded (void), growParmsIfNeeded (void);

/***********************************************************************
 * Request types
 * A request sent to the LPD daemon has the format:
 * \Xprinter [options],  where \X is a single character or byte value.
 * The following are the values and commands
 ***********************************************************************/

#define REQ_START	1	/* start printer */
#define REQ_RECV	2	/* transfer a job to the Host from a remote site */
#define REQ_DSHORT	3	/* print short form of queue status */
#define REQ_DLONG	4	/* print long form of queue status */
#define REQ_REMOVE	5	/* remove jobs */
#define REQ_CONTROL	6	/* do control operation */
/**************************************************************************
 *      Control file format
 *      First character is kind of entry, remainder of line is
 *          the argument.
 *
 *		1 -- "R font file" for troff -ignore
 *		2 -- "I font file" for troff -ignore
 *		3 -- "B font file" for troff -ignore
 *		4 -- "S font file" for troff -ignore
 *		C -- "class name" on banner page
 *		D -- "Date" job submitted
 *		H -- "Host name" of machine where lpr was done
 *		I -- "indent" amount to indent output
 *		J -- "job name" on banner page
 *		L -- "literal" user's name to print on banner
 *		M -- "mail" to user when done printing
 *		N -- "name" of file (used by lpq)
 *		P -- "Person" user's login name
 *		R -- account id  for charging
 *		U -- "unlink" name of file to remove after we print it
 *		W -- "width" page width for PR
 *		X -- "header" header title for PR
 *		Z -- xtra options to filters
 *
 *		Lower case letters are formats
 *		f -- "file name" name of text file to print
 *		l -- "file name" text file with control chars
 *		p -- "file name" text file to print with pr(1)
 *		t -- "file name" troff(1) file to print
 *		n -- "file name" ditroff(1) file to print
 *		d -- "file name" dvi file to print
 *		g -- "file name" plot(1G) file to print
 *		v -- "file name" plain raster file to print
 *		c -- "file name" cifplot file to print
 *
 * CFparm is used to hold the upper case parameters
 */
extern char CFparm[26][MAXPARMLEN + 1];
#define CLASSNAME CFparm['C'-'A']	/* RFC: 31 char limit */
#define WHENSP    CFparm['D'-'A']	/* PLP */
#define UNSPTIME  CFparm['E'-'A']	/* PLP */
#define FROMHOST  CFparm['H'-'A']	/* RFC: 31 char limit */
#define INDENT    CFparm['I'-'A']	/* RFC: number */
#define JOBNAME   CFparm['J'-'A']	/* RFC: 99 char limit */
#define BNRNAME   CFparm['L'-'A']	/* RFC: 31 char limit */
#define FILENAME  CFparm['N'-'A']	/* RFC: 131 char limit */
#define MAILNAME  CFparm['M'-'A']	/* RFC: ?? char limit */
#define LOGNAME   CFparm['P'-'A']	/* RFC: 31 char limit */
#define WHENQUED  CFparm['Q'-'A']	/* PLP */
#define ACCNTNAME CFparm['R'-'A']	/* PLP */
#define SLINKDATA CFparm['S'-'A']	/* RFC: number " " number */
#define PRTITLE   CFparm['T'-'A']	/* RFC: 79 char limit */
#define UNLNKFILE CFparm['U'-'A']	/* RFC: flag */
#define PWIDTH    CFparm['W'-'A']	/* RFC: number */
/*
 * NOTE: for some reason, earlier versions of PLP decided to violate the
 * RFC by using T for something else, and X for the title, so
 * we can't use X for anything for a while (so we keep compatibility).
 * Argh.
 * S records data for symlinks (security); this wasn't implemented
 * in earlier versions of PLP, and S was used to suppress banner.
 * implemented now because of security hole.
 */
#define ZOPTS     CFparm['Z'-'A']	/* PLP */

/*
 * printjob return codes
 */
#define JBUSY   -1		/* being done by other means */
#define JFAIL    0		/* failed - try later */
#define JSUCC    1		/* done */
#define JABORT   2		/* done, but problems */
#define JFULL	 3		/* remote system full - try later */
#define JNOCONF	 4		/* no confirm - assume it's been printed anyway */

/*
 * Mail program
 */
#ifndef MAIL
#define MAIL "/usr/lib/sendmail -oi -t"
#endif				/* MAIL */

/*
 * File Transfer Protocol Flags
 */
#define CEND	5		/* last file */
#define CNAME	4		/* control file */
#define DFILE	3		/* data file */
#define CFILE	2		/* control file */

/*
 * Local parameters to the spooling system Defaults for line printer capabilities data
 * base
 */
#define DEFLOGF		"log"
#define DEFLOCK		"lock"
#define DEFSTAT		"status"
#define	DEFFORMATS	"flp"	/* default formats */
#define	DEFMX		1000
#define	DEFRETRY	3	/* maximum number of retries */
#define DEFMAXCOPIES	0
#define DEFMINLEGAL	32	/* check only first 32 chars */
#define DEFFF		"\f"
#define DEFWIDTH	132
#define DEFLENGTH	66
#define DEFPRICE	20	/* cost in dollars per thousand pages */
#define DEFPRIORITY	'X'	/* default priority level */
#define DEFPR		"/bin/pr"	/* default pr program */

#ifndef DAEMON
#define DAEMON		"daemon"/* daemon user id */
#endif

#define DEF_OPTIONS     "-"	/* to indicate that no options have been specified */

#ifdef LOG_LPR
#define SYSLOG_FACILITY	LOG_LPR
#else
#ifdef LOG_LOCAL0
#define SYSLOG_FACILITY	LOCAL0
#else
#define SYSLOG_FACILITY	(0)	/* for Ultrix -- facilities aren't supported */
#endif
#endif

/*************************************************************************
 * jmason additions from here on (v3.3.0)
 */

/* there's AF_UNIX support in there too, but what's the point of that!? */
#define SOCK_FAMILY	AF_INET

#ifndef CONFIG_FILE
#define CONFIG_FILE     "/etc/plp.conf"
#endif

/*************************************************************************
 * Edinburgh additions:
 */

extern char *FL;		/* list of valid forms */
extern int ED;			/* Expensive device - only print jobs from trusted hosts */
extern int NC;			/* Non-charged queue of expensive device */

/* Printcap configuration stuff */

struct conf_entry {
    int type;
    char *domain;
};

#define MAX_CONFS 10		/* the max. no. of entries which we look at */
extern int num_confs;
extern struct conf_entry conf[MAX_CONFS];

#ifndef PNAME_SEPCH
#define PNAME_SEPCH '/'
#endif

/* CROSS_DOMAIN is used to enable cross-domain
 * NIS & Hesiod printcap searches. (EUCS feature)
 */

#ifdef NIS
#undef CROSS_DOMAIN
#define CROSS_DOMAIN
extern int NIS_order;
#endif

#ifdef HESIOD
#undef CROSS_DOMAIN
#define CROSS_DOMAIN

#define HES_ERR_OK 0		/* Hesiod error codes */
#define HES_ERR_NOTFOUND 1
#define HES_MAXHOSTLEN 64	/* Hesiod implementation limits */
#define HES_MAXKEYLEN 256

/* if anyone has trouble getting this to compile because of the
 * lack of arg prototypes, fix it and send me a patch.
 */
extern char **hes_resolve ();	/* Hesiod printcap entries: external linkage */
extern char **hesiod_match ();	/* Hesiod routines in read_config.c */
extern int hes_error ();
extern int Hesiod_order;	/* the "order" keyword */
#endif

#ifdef CROSS_DOMAIN
extern char *out_domain;	/* name of external domain in which match occurred */
#endif

#ifdef EUCS_ZOPTIONS
#define EUCS_FORMS
extern char *Forms_file;
#endif

/* for the printcap_*.c files: */
#define NO_CONT 0		/* don't look for continuations */
#define DO_CONT 1		/* look for continuations */

extern char *Errors_file;
extern char *Attach_file;

/*************************************************************************
 * jmason additions from here on (v3.3.1 and onwards)
 */

#define MAXUSERENVIRON  100		/* max no. of envs to keep */

#ifdef LOCAL
#define LOCAL_TYPE	1
#endif
#ifdef NIS
#define NIS_TYPE	2
#endif
#ifdef HESIOD
#define HESIOD_TYPE	3
#endif

#ifdef LOCAL
extern char *Permfile_path;
extern char *Printcap_path;
extern int Local_order;
#endif

#ifdef EUCS_ZOPTIONS
extern char *Zoptions_path;
extern char *Costcode_path;
extern char *Forms_active;
#endif

#ifdef HESIOD
extern int *Hesiod_cross_domain;
extern char *Hesiod_printcap_key;
extern char *Hesiod_costcode_key;
#endif

#ifdef NIS
extern char *NIS_printcap_bykey;
extern char *NIS_printcap_byname;
extern char *NIS_costcode_bykey;
extern char *NIS_costcode_byname;
#endif

#ifdef EUCS_BANNER
extern char EUCS_banner_format;
#endif

extern FILE *fopen_path (char *, char *);

extern char *ConfigFile;

extern char *Daemon_user, *Mail_command, *Mail_addressing;
extern char *Mail_from_address, *Ctrlfile_logdir, *DefaultPrintcap;
extern char *Filter_path, *Filter_LD_path, *Printer_port, *Host_domain;
extern char *Printcap_include_path, *Config_include_path;
extern char *Permfile_include_path;

extern char AllowNonPrivPorts, LogNonPrivPorts, Mail_on_errors, Restrict_symlinks;
extern char Log_no_filenames, Log_LPRMs, Log_LPQs, Log_LPCs, Log_LPRs;
extern char Check_for_nonprintable, Show_empty_queues;
extern char DomainNameUnset, Use_EUID, Use_printcap_cache, Use_perm_cache;

extern char *SafeEnviron[MAXUSERENVIRON];

/* Additions by B. Steinsbo */
#ifndef NGROUPS_MAX		/* number of simultaneous groups */
#ifdef NGROUPS
#define NGROUPS_MAX	NGROUPS
#else
#define NGROUPS_MAX	255
#endif
#endif

#ifndef GRP_NAM_MAX		/* max length of a group name */
#define GRP_NAM_MAX	15
#endif

extern uid_t UserUID;

extern char *reallocstrcpy (char *, char *, int);
#define allocandcpy_len(to,from,len)	to = reallocstrcpy(to,from,len)
#define allocandcpy(to,from)		to = reallocstrcpy(to,from,0)

extern char *Malloc_failed_msg;
/*
 * The code used to check to make sure dynamic arrays have space left and realloc to the
 * maximum size. If these are macros, it saves lots of tricky handle-passing.
 */
#define chkandrealloc_str(BUFFER,INDEX,ARYSZ,SZINCREMENT)		\
  if (BUFFER == NULL) {							\
    if (!(BUFFER = (char *) malloc(ARYSZ)))				\
    { logerr_die(XLOG_NOTICE, Malloc_failed_msg); }			\
  }									\
  if ((INDEX >= ARYSZ - 1) && (ARYSZ > 1)) {				\
    ARYSZ += SZINCREMENT;     /* try to fatten the buffer */		\
    if (!(BUFFER = (char *) realloc(BUFFER, ARYSZ)))			\
    { logerr_die(XLOG_NOTICE, Malloc_failed_msg); }			\
  }

#define chkandrealloc_list(BUFFER,INDEX,ARYSZ,SZINCREMENT)		\
  if (BUFFER == NULL) {							\
    if (!(BUFFER = (char **)malloc(sizeof(char *)*ARYSZ)))		\
    { logerr_die(XLOG_NOTICE, Malloc_failed_msg); }			\
  }									\
  if ((INDEX >= ARYSZ - 1) && (ARYSZ > 1)) {				\
    ARYSZ += SZINCREMENT;     /* try to fatten the buffer */		\
    if (!(BUFFER = (char **) realloc(BUFFER,sizeof(char *)*ARYSZ)))	\
    { logerr_die(XLOG_NOTICE, Malloc_failed_msg); }			\
  }

extern void full_root_to_user (void), full_root_to_daemon (void),
	full_root_perms (void), root_to_user (void), root_to_daemon (void),
	user_to_root (void), user_to_daemon (void), daemon_to_root (void),
	daemon_to_user (void), set_user_uid (int), Setuid_debug (char *),
	full_daemon_perms (void), full_user_perms (void);

extern int secure_system (char *);
extern void secure_exec (char *);

extern void hires_time (unsigned long *, unsigned long *);

extern DIR *opendir_SD (void);
extern void chdir_SD (void), fix_SD (void);

extern char DbgPcap, DbgRem, DbgLocal, DbgConf, DbgPerms;

#define malloc_or_die(x,y)	if (((x) = malloc((unsigned) y)) == 0) { \
				  logerr_die (XLOG_INFO, Malloc_failed_msg); \
				}

#ifdef HAVE_WAITPID
#define plp_waitpid(x,y,z)	waitpid(x,y,z)
#else
#define plp_waitpid(x,y,z)	((pid_t) wait3 (y, z, (struct rusage *) NULL))
/* extern pid_t plp_waitpid (); -- hack on this if you want; see bsd-compat.c */
#endif

extern void plp_block_signals (void), plp_unblock_signals (void),
	setup_clean_fds (void), setup_close_on_exec (void),
	Parse_debug (char *);

extern void Log_cf (char *, char *, int);
extern char **copy_haddr_list (char **);
extern void free_haddr_list (char **);
extern int copy_file (char *, char *, int);

/* easier to read than strcmp(s1,s2) == 0; may be faster, too. */
#define strsame(s1, s2)		((*(s1) == *(s2)) && (strcmp((s1), (s2)) == 0))

/*************************************************************************
 * Some default values -- I think these are correct.
 */

#undef NO_SYMLINKS		/* define this to disable lpr -s */

#define YP_GET_DOMAIN_BROKEN	/* yp_get_default_domain() doesn't use malloc() for
				   return data address. */

/* these are set to default values in the NIS code. */

/* #undef YP_BIND_RETURNS */	/* if yp_bind to bad domain returns YPERR_DOMAIN */
/* #undef YP_FORK */		/* fork to implement NIS timeout because yp_bind
				   doesn't return and can't be interrupted by
				   SIGALRM */
/* #define YP_BIND_TIMEOUT	2 */	/* timeout period for yp_bind (secs) */

#ifndef ARCHITECTURE
#define ARCHITECTURE	"unknown"
#endif

#define AUTOMOUNT_STR   "/tmp_mnt/"
#define AUTOMOUNT_LEN   9		/* strlen of AUTOMOUNT_STR, basically */

#endif	/* PLP_LP_H */
