/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: termclear.c
 ***************************************************************************
 * 1. Do the initialization if neccessary
 * 2. clear the screen using the termcap information
 ***************************************************************************/

#include <stdio.h>
#include "lp.h"

#ifdef TERMCAP
#ifdef HAVE_TERMCAP_H
#include <termcap.h>
#endif
#endif

/* terminfo has a termcap emulation */
#ifdef TERMINFO
#ifdef HAVE_CURSES_H
#include <curses.h>
#endif
#endif

#if defined(TERMCAP) || defined(TERMINFO)
static int tinit_done;
static char *TE;
static char *CL;

/*
 * Michael Haardt: stop users from overwriting buffer.
 * this won't stop them, but it'll make it harder.
 */
static char bp[2048];
static char xp[2048];
static char *area = xp;

static inline int pputs(int c) {
  putchar(c);
}

void Term_clear(void) {
    char *sp,*ti;

    if (tinit_done == 0) 
    {
	tinit_done = 1;
	if (isatty (0) && (sp = getenv ("TERM")) != (char*)0) 
	{
	    if (tgetent (bp, sp) > 0) 
	    {
		if ((ti=tgetstr ("ti", &area))!=(char*)0) tputs(ti,0,pputs);
		TE = tgetstr ("te", &area);
		CL = tgetstr ("cl", &area);
	    }
	}
    }
    if (CL) tputs (CL, 0, pputs);
    fflush(stdout);
}

void Term_finish(void)
{
    if (TE) tputs (TE, 0, pputs);
    fflush(stdout);
}

#else

void Term_clear(void) {;}
void Term_finish(void) {;}

#endif
