/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 * version 3.3.0 Justin Mason July 1994
 * POSIX: termios.
 ***************************************************************************/

#ifndef HAVE_TCSETATTR
#define tcgetattr(fd,tdat)		(ioctl ((fd), TCGETS, (tdat)))
#define tcsetattr(fd,flags,tdat)	(ioctl ((fd), TCSETS, (tdat)))
					/* ignore the flags arg. */
#endif

struct bauds {
    char *string;
    int baud;
    int speed;
}     bauds[] = {

    "110", 110, B110,
    "134", 134, B134,
    "150", 150, B150,
    "300", 300, B300,
    "600", 600, B600,
    "1200", 1200, B1200,
    "1800", 1800, B1800,
    "2400", 2400, B2400,
    "4800", 4800, B4800,
    "9600", 9600, B9600,
    "19200", 19200, B19200,
    "38400", 38400, B38400,
    (char *) 0, 0, 0
};

struct s_term_dat {
    char *name;
    uint or_dat;
    uint and_dat;
};

/* c_iflag bits */
static struct s_term_dat c_i_dat[] =
{
    {"IGNBRK", IGNBRK, 0},
    {"-IGNBRK", 0, IGNBRK},
    {"BRKINT", BRKINT, 0},
    {"-BRKINT", 0, BRKINT},
    {"IGNPAR", IGNPAR, 0},
    {"-IGNPAR", 0, IGNPAR},
    {"PARMRK", PARMRK, 0},
    {"-PARMRK", 0, PARMRK},
    {"INPCK", INPCK, 0},
    {"-INPCK", 0, INPCK},
    {"ISTRIP", ISTRIP, 0},
    {"-ISTRIP", 0, ISTRIP},
    {"INLCR", INLCR, 0},
    {"-INLCR", 0, INLCR},
    {"IGNCR", IGNCR, 0},
    {"-IGNCR", 0, IGNCR},
    {"ICRNL", ICRNL, 0},
    {"-ICRNL", 0, ICRNL},
    {"IUCLC", IUCLC, 0},
    {"-IUCLC", 0, IUCLC},
    {"IXON", IXON, 0},
    {"-IXON", 0, IXON},
    {"IXANY", IXANY, 0},
    {"-IXANY", 0, IXANY},
    {"IXOFF", IXOFF, 0},
    {"-IXOFF", 0, IXOFF},

#ifdef IMAXBEL
    {"IMAXBEL", IMAXBEL, 0},
    {"-IMAXBEL", 0, IMAXBEL},
#else
    /* work out what they do and simulate with IFLAGONE|IFLAGTWO */
#endif

    /* jmason addition: */
    {"PASS8", 0, ISTRIP},
    {"-PASS8", ISTRIP, 0},
    {NULL, 0, 0}
};

/* c_oflag bits */
static struct s_term_dat c_o_dat[] =
{
    {"OPOST", OPOST, 0},
    {"-OPOST", 0, OPOST},
    {"OLCUC", OLCUC, 0},
    {"-OLCUC", 0, OLCUC},
    {"ONLCR", ONLCR, 0},
    {"-ONLCR", 0, ONLCR},
    {"OCRNL", OCRNL, 0},
    {"-OCRNL", 0, OCRNL},
    {"ONOCR", ONOCR, 0},
    {"-ONOCR", 0, ONOCR},
    {"ONLRET", ONLRET, 0},
    {"-ONLRET", 0, ONLRET},
    {"OFILL", OFILL, 0},
    {"-OFILL", 0, OFILL},
    {"OFDEL", OFDEL, 0},
    {"-OFDEL", 0, OFDEL},
    {"NL0", 0, NLDLY},
    {"NL1", NL1, NLDLY},
    {"CR0", CR0, CRDLY},
    {"CR1", CR1, CRDLY},
    {"CR2", CR2, CRDLY},
    {"CR3", CR3, CRDLY},
    {"TAB0", TAB0, TABDLY},
    {"TAB1", TAB1, TABDLY},
    {"TAB2", TAB2, TABDLY},
    {"TAB3", TAB3, TABDLY},
    {"BS0", BS0, BSDLY},
    {"BS1", BS1, BSDLY},
    {"VT0", VT0, VTDLY},
    {"VT1", VT1, VTDLY},
    {"FF0", FF0, FFDLY},
    {"FF1", FF1, FFDLY},

    /* jmason addition: */
    {"TABS", TAB3, TABDLY},
    {NULL, 0, 0}
};

/* c_cflag bit meaning */
static struct s_term_dat c_c_dat[] =
{
    {"B0", B0, CBAUD},
    {"0", B0, CBAUD},
    {"B50", B50, CBAUD},
    {"50", B50, CBAUD},
    {"B75", B75, CBAUD},
    {"75", B75, CBAUD},
    {"B110", B110, CBAUD},
    {"110", B110, CBAUD},
    {"B134", B134, CBAUD},
    {"134", B134, CBAUD},
    {"B150", B150, CBAUD},
    {"150", B150, CBAUD},
    {"B200", B200, CBAUD},
    {"200", B200, CBAUD},
    {"B300", B300, CBAUD},
    {"300", B300, CBAUD},
    {"B600", B600, CBAUD},
    {"600", B600, CBAUD},
    {"B1200", B1200, CBAUD},
    {"1200 ", B1200, CBAUD},
    {"B1800", B1800, CBAUD},
    {"1800", B1800, CBAUD},
    {"B2400", B2400, CBAUD},
    {"2400", B2400, CBAUD},
    {"B4800", B4800, CBAUD},
    {"4800", B4800, CBAUD},
    {"B9600", B9600, CBAUD},
    {"9600", B9600, CBAUD},
    {"B19200", B19200, CBAUD},
    {"19200", B19200, CBAUD},
    {"B38400", B38400, CBAUD},
    {"38400", B38400, CBAUD},
    {"EXTA", EXTA, CBAUD},
    {"EXTB", EXTB, CBAUD},
    {"CS5", CS5, CSIZE},
    {"CS6", CS6, CSIZE},
    {"CS7", CS7, CSIZE},
    {"CS8", CS8, CSIZE},
    {"CSTOPB", CSTOPB, 0},
    {"-CSTOPB", 0, CSTOPB},
    {"CREAD", CREAD, 0},
    {"-CREAD", 0, CREAD},
    {"PARENB", PARENB, 0},
    {"-PARENB", 0, PARENB},
    {"PARODD", PARODD, 0},
    {"-PARODD", 0, PARODD},
    {"HUPCL", HUPCL, 0},
    {"-HUPCL", 0, HUPCL},
    {"CLOCAL", CLOCAL, 0},
    {"-CLOCAL", 0, CLOCAL},

#ifdef CRTSCTS
    /* work out what they do and simulate with IFLAGONE|IFLAGTWO */
    {"CRTSCTS", CRTSCTS, 0},
    {"-CRTSCTS", 0, CRTSCTS},
#endif

    /* jmason additions, from SunOS stty(1v) combination modes: */
    {"EVENP", PARENB | CS7, PARODD | CSIZE},
    {"-EVENP", CS8, PARENB | CSIZE},
    {"PARITY", PARENB | CS7, PARODD | CSIZE},
    {"-PARITY", CS8, PARENB | CSIZE},
    {"ODDP", PARENB | CS7, CSIZE},
    {"-ODDP", CS8, PARENB | PARODD | CSIZE},
    {"PASS8", CS8, PARENB | CSIZE},
    {"-PASS8", PARENB | CS7, CSIZE},
    {NULL, 0, 0}
};

/* c_lflag bits */
static struct s_term_dat c_l_dat[] =
{
    {"ISIG", ISIG, 0},
    {"-ISIG", 0, ISIG},
    {"ICANON", ICANON, 0},
    {"-ICANON", 0, ICANON},
    {"XCASE", XCASE, 0},
    {"-XCASE", 0, XCASE},
    {"ECHO", ECHO, 0},
    {"-ECHO", 0, ECHO},
    {"ECHOE", ECHOE, 0},
    {"-ECHOE", 0, ECHOE},
    {"ECHOK", ECHOK, 0},
    {"-ECHOK", 0, ECHOK},
    {"ECHONL", ECHONL, 0},
    {"-ECHONL", 0, ECHONL},
    {"NOFLSH", NOFLSH, 0},
    {"-NOFLSH", 0, NOFLSH},
    {"TOSTOP", TOSTOP, 0},
    {"-TOSTOP", 0, TOSTOP},
    {"IEXTEN", IEXTEN, 0},
    {"-IEXTEN", 0, IEXTEN},

#ifdef ECHOCTL
    {"ECHOCTL", ECHOCTL, 0},
    {"-ECHOCTL", 0, ECHOCTL},
    {"CTLECHO", ECHOCTL, 0},
    {"-CTLECHO", 0, ECHOCTL},
#else
    /* work out what they do and simulate with IFLAGONE|IFLAGTWO */
#endif
#ifdef ECHOPRT
    {"ECHOPRT", ECHOPRT, 0},
    {"-ECHOPRT", 0, ECHOPRT},
    {"PRTERASE", ECHOPRT, 0},
    {"-PRTERASE", 0, ECHOPRT},
    /* ditto etc. -- you get the story */
#endif
#ifdef ECHOKE
    {"ECHOKE", ECHOKE, 0},
    {"-ECHOKE", 0, ECHOKE},
    {"CRTKILL", ECHOKE, 0},
    {"-CRTKILL", 0, ECHOKE},
#endif
#ifdef FLUSHO
    {"FLUSHO", FLUSHO, 0},
    {"-FLUSHO", 0, FLUSHO},
#endif
#ifdef PENDIN
    {"PENDIN", PENDIN, 0},
    {"-PENDIN", 0, PENDIN},
#endif

    {NULL, 0, 0}
};

struct termios t_dat;

static struct special {
    char *name;
    char *cp;
}       special[] = {

    "stop", &(t_dat.c_cc[VSTOP]),
    "start", &(t_dat.c_cc[VSTART]),
    0
};

void
Do_stty (int fd) {
    int i;
    char buf[BUFSIZ], *bp, *ep, *arg;

    if (tcgetattr (fd, &t_dat) < 0) {
	logerr_die (XLOG_INFO, "cannot get tty parameters");
    }
    if (DbgLocal > 3)
	log (XLOG_DEBUG, "stty: before iflag 0x%x, oflag 0x%x, cflag 0x%x lflag 0x%x",
	     t_dat.c_iflag, t_dat.c_oflag, t_dat.c_cflag, t_dat.c_lflag);
    if (BR) {
	for (i = 0; bauds[i].baud && BR != bauds[i].baud; i++);
	if (i == 0) {
	    fatal (XLOG_INFO, "illegal baud rate %d", BR);
	}
        if (Debug > 3)
            log (XLOG_DEBUG, "stty: before baudrate : cflag 0x%x",t_dat.c_cflag);

#ifdef HAVE_CFSETISPEED
	/* POSIX baudrate manipulation */
	cfsetispeed (&t_dat, bauds[i].speed);
	cfsetospeed (&t_dat, bauds[i].speed);
#else
	t_dat.c_cflag &= ~CBAUD;
	t_dat.c_cflag |= bauds[i].speed;
#endif

        if (Debug > 3)
            log (XLOG_DEBUG, "stty: after baudrate : cflag 0x%x",t_dat.c_cflag);
    }
    t_dat.c_cflag &= ~FC;
    t_dat.c_cflag |= FS;
    t_dat.c_lflag &= ~XC;
    t_dat.c_lflag |= XS;

    if (TY && *TY) {
	(void) strcpy (buf, TY);
	ep = buf;
    } else if (MS && *MS) {
	(void) strcpy (buf, MS);
	ep = buf;
    } else {
	ep = 0;
    }
    while (ep && *ep) {
	for (; *ep && isspace (*ep); ++ep);
	for (arg = ep; *ep && !isspace (*ep); ++ep) {
	    *ep = toupper (*ep);
	}
	if (*ep) {
	    *ep = 0;
	    ++ep;
	}
	for (i = 0; c_i_dat[i].name && strcmp (c_i_dat[i].name, arg); i++);
	if (c_i_dat[i].name) {
	    if (DbgLocal > 4)
		log (XLOG_DEBUG,
		     "stty: c_iflag %s, ms 0x%x mc 0x%x",
		     c_i_dat[i].name, c_i_dat[i].or_dat, c_i_dat[i].and_dat);
	    t_dat.c_iflag &= ~(c_i_dat[i].and_dat);
	    t_dat.c_iflag |= c_i_dat[i].or_dat;
	    continue;
	}
	for (i = 0; c_o_dat[i].name && strcmp (c_o_dat[i].name, arg); i++);
	if (c_o_dat[i].name) {
	    if (DbgLocal > 4)
		log (XLOG_DEBUG,
		     "stty: c_oflag %s, ms 0x%x mc 0x%x",
		     c_o_dat[i].name, c_o_dat[i].or_dat, c_o_dat[i].and_dat);
	    t_dat.c_oflag &= ~(c_o_dat[i].and_dat);
	    t_dat.c_oflag |= c_o_dat[i].or_dat;
	    continue;
	}
	for (i = 0; c_c_dat[i].name && strcmp (c_c_dat[i].name, arg); i++);
	if (c_c_dat[i].name) {
	    if (DbgLocal > 4)
		log (XLOG_DEBUG,
		     "stty: c_cflag %s, ms 0x%x mc 0x%x",
		     c_c_dat[i].name, c_c_dat[i].or_dat, c_c_dat[i].and_dat);
	    t_dat.c_cflag &= ~(c_c_dat[i].and_dat);
	    t_dat.c_cflag |= c_c_dat[i].or_dat;
	    continue;
	}
	for (i = 0; c_l_dat[i].name && strcmp (c_l_dat[i].name, arg); i++);
	if (c_l_dat[i].name) {
	    if (DbgLocal > 4)
		log (XLOG_DEBUG,
		     "stty: c_lflag %s, ms 0x%x mc 0x%x",
		     c_l_dat[i].name, c_l_dat[i].or_dat, c_l_dat[i].and_dat);
	    t_dat.c_lflag &= ~(c_l_dat[i].and_dat);
	    t_dat.c_lflag |= c_l_dat[i].or_dat;
	    continue;
	}
	for (i = 0; special[i].name && strcmp (special[i].name, arg); i++);
	if (special[i].name) {
	    for (; *ep && isspace (*ep); ++ep);
	    for (bp = ep; *ep && !isspace (*ep); ++ep);
	    if (*ep) {
		*ep = 0;
		++ep;
	    }
	    if (*bp == 0) {
		fatal (XLOG_INFO, "stty: missing parameter for %s", arg);
	    }
	    if (bp[0] == '^') {
		if (bp[1] == '?') {
		    *special[i].cp = 0177;
		} else {
		    *special[i].cp = 037 & bp[1];
		}
	    } else {
		*special[i].cp = bp[0];
	    }
	    if (DbgLocal > 4)
		log (XLOG_DEBUG, "stty: special %s %s", arg, bp);
	    continue;
	}
	fatal (XLOG_INFO, "unknown mode: %s\n", arg);
    }

    if (RW && (t_dat.c_lflag & ICANON) == 0) {
	/* only do this if ICANON is off -- Martin Forssen */
	if (DbgLocal > 3)
	    log (XLOG_DEBUG,
		"setting port to read/write with unbuffered reads (MIN=1, TIME=0)");
	t_dat.c_cc[VMIN] = 1;
	t_dat.c_cc[VTIME] = 0;
    }
    if (DbgLocal > 3)
	log (XLOG_DEBUG, "stty: after iflag 0x%x, oflag 0x%x, cflag 0x%x lflag 0x%x",
	     t_dat.c_iflag, t_dat.c_oflag, t_dat.c_cflag, t_dat.c_lflag);

    if (tcsetattr (fd, TCSANOW, &t_dat) < 0) {
	logerr_die (XLOG_NOTICE, "cannot set tty parameters");
    }
}
