/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 * version 3.3.0 Justin Mason July 1994
 ***************************************************************************
 * MODULE: sendmail.c
 * send mail to user on completion of a job
 ***************************************************************************/

#include "lp.h"
#include "library/errormsg.h"

extern void Make_mail_address (char *, char *, char *, char *);

static void
mail_error (FILE *mail) {
    FILE *error_fp;
    char buf[BUFSIZ];

    if (*Errors_file) {
	if ((error_fp = fopen_daemon (Errors_file, "r")) != NULL) {
	    fputc ('\n', mail);
	    while (fgets (buf, sizeof (buf), error_fp)) {
		fputs (buf, mail);
	    }
	    fclose (error_fp);
	    if (unlink_daemon (Errors_file) != 0)
		log (XLOG_INFO, "couldn't unlink errors file '%s'",
			Errors_file);
	}
    }
}

/*
 * sendmail --- tell people about job completion 1. fork a sendmail process 2. if
 * successful, send the good news 3. if unsuccessful, send the bad news
 */
void
sendmail (struct plp_queue *q, int status) {
    static int p[2];		/* pipe */
    int i;			/* ACME Integer, Inc. */
    char buf[100];		/* command line to run */
    char toaddr[511];		/* To: address */
    FILE *mail;			/* mail file */
    int pid;			/* sendmail process */
    plp_status_t stat;		/* daughter status */

    /*
     * check to see if the user really wanted a "your file was printed ok" message
     */
    if (!MAILNAME[0]) {
	if (status == JSUCC) {
	    if (Debug > 3)
		log (XLOG_DEBUG, "success mail is unwanted");
	    return;
	} else if (!Mail_on_errors) {
	    if (Debug > 3)
		log (XLOG_DEBUG, "failure mail is unwanted");
	    return;
	}
    }
    if (!Mail_command || !*Mail_command) {
	if (Debug > 3)
	    log (XLOG_DEBUG, "mail is turned off");
	return;
    }
    (void) strcpy (buf, Mail_command);
    if (Debug > 3)
	log (XLOG_DEBUG, "mail command: %s", buf);

    if (MAILNAME && MAILNAME[0]) {
	/* lpr provided it -- thanks lpr! */
	(void) strcpy (toaddr, MAILNAME);
    } else {
	/* we have to make it ourselves and hope for the best */
	if (q && q->q_user) {
	    Make_mail_address (toaddr, Mail_addressing, q->q_user, &(q->q_from));
	} else {
	    Make_mail_address (toaddr, Mail_addressing, LOGNAME, FROMHOST);
	}
    }

    if (Debug > 4)
	log (XLOG_DEBUG, "sendmail to: %s", toaddr);

    if (pipe (p) < 0) {
	logerr_die (XLOG_NOTICE, "pipe failed for sendmail");
    }

    (void) plp_signal (SIGCHLD, (plp_sigfunc_t)SIG_IGN);   /* don't reap this one */

    /*
     * start up sendmail process
     */
    if ((pid = fork ()) == 0) {
	if (p[0]) {
	    if (dup2 (p[0], 0) < 0) {
		logerr_die (XLOG_NOTICE, "dup2 failed in sendmail child");
	    }
	}
	/* run as "daemon" user so headers are legal */
	full_daemon_perms ();

	setup_close_on_exec (); /* this'll close the unused pipe fds */
	secure_exec (buf);

    } else if (pid < 0) {	/* parent */
	logerr_die (XLOG_NOTICE, "sendmail: fork failed");
    }
    (void) close (p[0]);
    if ((mail = fdopen (p[1], "w")) == NULL) {
	logerr_die (XLOG_NOTICE, "sendmail: fdopen failed");
    }
    (void) fprintf (mail, "From: %s\n", Mail_from_address);
    if (status != JSUCC) {
	/* Cc the printer operator (via .forward or alias) in case
	 * of printer error.
	 */
	(void) fprintf (mail, "Cc: %s\n", Mail_from_address);
    }
    (void) fprintf (mail, "To: %s\n", toaddr);
    (void) fprintf (mail, "Subject: %s printer job\n\n", Printer);

    (void) fprintf (mail, "Your %s printer job", Printer);
    if (q) {
	char *s;
	int l;
	/* q->q_data has a trailing space, for some reason. gak. */
	l = strlen (q->q_data); s = (char *) malloc (l);
	(void) strncpy (s, q->q_data, l - 1); s[l - 1] = '\0';
	(void) fprintf (mail, " %d (%s)", q->q_num, s);
	free (s);
    }
    switch (status) {
    case JSUCC:
	(void) fprintf (mail, " was successful.\n");
	break;

    case JFAIL:
	(void) fprintf (mail, " failed, and retry count was exceeded.\n");
	goto the_msg_was;

    default:
	(void) fprintf (mail, " died a horrible death.\n");

    the_msg_was:
	(void) fprintf (mail, "\nThe error message was:\n%s\n", Last_errormsg);
	mail_error (mail);
	break;
    }

    (void) fflush (mail);
    (void) fclose (mail);
    i = plp_waitpid (pid, &stat, WUNTRACED);
    if (Debug > 3)
	log (XLOG_DEBUG, "sendmail: %d finished (%s)",
	     i, Decode_status (&stat));
}
