/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: vdmp.c
 ***************************************************************************
 * Revision History: Created (Well, sort of) Fri Mar  4 19:15:16 CST 1988
 * $Log: vdmp.c,v $
 * Revision 2.1  88/05/09  10:12:17  papowell
 * *** empty log message ***
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: /disk/home/src2/plp/work_area/filters/RCS/vdmp.c,v 2.1 1988/05/09 10:12:17 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint
/*
 *  reads raster file created by cifplot or plot and dumps it onto the
 *  Varian or Versatec plotter.   Originally derived from the 1984
 *  Berkeley VLSI Tools Distribution.  Has been mangled horribly ever
 *  since.  This code has little redeeming social value.
 *
 *  Note that the number of bits per raster line is given by xwidth.
 *  If vdmp is invoked with -Zr flag, it runs in raw mode, and does not
 *  check for header.
 *  If vdmp is invoked with -Zw flag, it puts out a couple of lines
 *	at end, otherwise a page eject (FF).
 *  It is assumed that BLOCK, the numbers of bytes in the header,
 *  fits in BUFSIZE.
 */
#include <stdio.h>
#include <sys/vcmd.h>
#include <sys/types.h>
#include <sys/signal.h>

#define IN	0	/* input fcd */
#define OUT	1	/* output fcd */

#define MAGIC_WORD	0xA5CF4DFA		/* hardwired to the VAX, no doubt */
char magic_string[4] = { 0xFA, 0x4D, 0xCF, 0xA5 };

#define BLOCK		1024
#define BUFSIZE		BLOCK*128


int	plotmd[] = { VPLOT };
int	prtmd[]	= { VPRINT };

char	buf[BUFSIZE];
int	lines;		/* number of scan lines */

int	raw;			/* 1 if -Zr, no check for header */
int	wide;			/* 1 if -Zw, terminate with couple of lines, else FF */
int	nscanbytes;		/* number of bytes per raster line. */
extern int xwidth;		/* width in pixcels */
extern int ylength;		/* number of raster lines per page. */
extern int npages;		/* number of billable pages */
extern int errorcode;		/* 1 = retry, 2 = give up */
extern char *zopts, *index();	/* -Z options to LPR */

int	timeout();
#define	TIMEOUT	(5*60)		/* 5 minutes */
time_t	t, time();

filter()
{
	int n;
	char *trailer;

	if( xwidth <= 0 ){
		fatal( "bad xwidth value %d", xwidth );
	}
	if( ylength <= 0 ){
		fatal( "bad ylength value %d", ylength );
	}
	nscanbytes = xwidth / 8;
	
	/*
	 * check for -Zrw (raw and wide flag);
	 */
	if( zopts && index( zopts, 'r' ) ){
		raw = 1;
	}
	if( zopts && index( zopts, 'w' ) ){
		wide = 1;
	}
	/*
	 * check the start of the file for a Magic Word
	 * if there is one, print the string in the header
	 */

	errorcode = 2;	/* no retry */

	if( raw == 0 ){
		(void)signal(SIGALRM, timeout);
		if( (n = read(IN, buf, BLOCK)) < 0 ){
			logerr_die( "read error from file" );
		}

		errorcode = 1;	/* retry on error */

		if( n==BLOCK && bcmp( buf, magic_string, 4 ) == 0 ){
			(void) alarm(TIMEOUT);
			buf[BLOCK] = 0;
			if( ioctl(OUT, VSETSTATE, prtmd) < 0 ){
				logerr_die( "ioctl for print mode failed" );
			}
			write(OUT, buf+4, strlen(buf+4));
			if( write(OUT, "\n", 1) != 1 ){
				logerr_die( "write of header failed" );
			}
			(void)alarm(0);
		} else if( lseek(IN, 0L, 0) ){
			/* dump file not formatted */
			logerr_die( "lseek failed" );
		}
	}

	errorcode = 1;	/* retry on error */
	n = putplot();
	if( lines ){
		++npages;
	}

	/* page feed */
	(void)alarm(TIMEOUT);
	if( ioctl(OUT, VSETSTATE, prtmd) < 0 ){
		logerr_die( "ioctl failed" );
	}
	if (wide)
		trailer = "\n\n\n\n\n";
	else
		trailer = "\f";
	if( write( OUT, trailer, strlen(trailer) ) != strlen(trailer) ){
		logerr_die( "trailer write failed" );
	}
	(void)alarm(0);
}

putplot()
{
	int bytes, n;

	bytes = 0;
	(void)alarm(TIMEOUT);
	if( ioctl(OUT, VSETSTATE, plotmd) < 0 ){
		logerr_die( "ioctl to plot mode failed" );
	}
	(void)alarm(0);
	while ((n = read(IN, buf, sizeof(buf))) > 0) {
		(void)alarm(TIMEOUT);
		if (write(OUT,buf, n) != n)
			logerr_die( "write failed" );
		(void)alarm(0);
		bytes += n;
		while( bytes >= nscanbytes ){
			++lines;
			if( lines >= ylength ){
				++npages;
				lines -= ylength;
			}
			bytes -= nscanbytes;
		}
	}
	/*
	 * Make sure we send complete raster lines.
	 */
	if (bytes > 0) {
		n = nscanbytes - bytes;
		if (n > 0){
			bzero(buf, n);
			(void)alarm(TIMEOUT);
			if (write(OUT, buf, n) != n)
				logerr_die( "write failed" );
			(void)alarm(0);
			bytes += n;
		}
		while( bytes >= nscanbytes ){
			++lines;
			if( lines >= ylength ){
				++npages;
				lines -= ylength;
			}
			bytes -= nscanbytes;
		}
	}
}

/*
 *	Die on timeout
 */
timeout()
    {
	errorcode = 1;
	logerr_die( "timeout" );
    }

cleanup() {}	/* dummy for error actions */
