/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: main.c for filters
 ***************************************************************************
 * Revision History: Created Fri Mar  4 19:45:03 CST 1988
 * $Log: main.c,v $
 * Revision 2.2.3.1  1994/04/07  16:11:49  jst
 * Fixed a missing parameter (which the pre-ANSI compiler never noticed!)
 * and included unistd.h (needed for the access() call).
 *
 * Revision 2.2  88/05/19  07:36:17  papowell
 * Added a -D (debug) flag
 * 
 * Revision 2.1  88/05/09  10:12:10  papowell
 * *** empty log message ***
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: /disk/home/src2/plp/work_area/filters/RCS/main.c,v 2.2.3.1 1994/04/07 16:11:49 jst Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint
/***************************************************************************
 *  UMN-LPR filter template and frontend.
 *
 *	A filter is invoked with the following parameters,
 *  which can be in any order, and perhaps some missing.
 *
 *  filtername arguments \   <- from PRINTCAP entry
 *      -PPrinter -wwidth -llength -xwidth -ylength [-c] [-iindent] \
 *		[-Zoptions] [-Cclass] [-Jjob] [-Raccntname] -nlogin -hHost  \
 *      -Fformat -Ddebug [affile]
 * 
 *  1. Parameters can be in different order than the above.
 *  2. Optional parameters can be missing
 *  3. Values specified for the width, length, etc., are from PRINTCAP
 *     or from the overridding user specified options.
 *
 *  This program provides a common front end for most of the necessary
 *  grunt work.  This falls into the following classes:
 * 1. Parameter extraction.
 * 2. Suspension when used as the "of" filter.
 * 3. Termination and accounting
 *  The front end will extract parameters,  then call the filter()
 *  routine,  which is responsible for carrying out the required filter
 *  actions. filter() is invoked with the printer device on fd 1,
 *	and error log on fd 2.  The npages variable is used to record the
 *  number of pages that were used.
 *  The "halt string", which is a sequence of characters that
 *  should cause the filter to suspend itself, is passed to filter.
 *  When these characters are detected,  the "suspend()" routine should be
 *  called.
 *
 *  On successful termination,  the accounting file will be updated.
 *
 *  The filter() routine should return 0 (success), 1 (retry) or 2 (abort).
 *
 * Parameter Extraction
 *	The main() routine will extract parameters
 *  whose values are placed in the appropriate variables.  This is done
 *  by using the ParmTable[], which has entries for each valid letter
 *  parmeter, such as the letter flag, the type of variable,
 *  and the address of the variable.
 *  The following variables are provided as a default set.
 *      -PPrinter -wwidth -llength -xwidth -ylength [-c] [-iindent] \
 *		[-Zoptions] [-Cclass] [-Jjob] [-Raccntname] -nlogin -hHost  \
 *      -Fformat [affile]
 * VARIABLE  FLAG          TYPE    PURPOSE / PRINTCAP ENTRTY
 * name     name of filter char*    argv[0], program identification
 * width    -wwidth	       int      PW, width in chars
 * length   -llength	   int      PL, length in lines
 * xwidth   -xwidth        int      PX, width in pixels
 * xlength  -xlength       int      PY, length in pixels
 * literal  -c	           int      if set, ignore control chars
 * indent   -iindent       int      indent amount (depends on device)
 * zopts    -Zoptions      char*    extra options for printer
 * class    -Cclass        char*    classname
 * job      -Jjob          char*    jobname
 * accntname -Raccntname   char*    account for billing purposes
 * login    -nlogin        char*    login name
 * host     -hhost         char*    host name
 * format   -Fformat       char*    format
 * special   -snumber      int      Special Variable for passing flags
 * accntfile file          char*    AF, accounting file
 *
 * npages    - number of pages for accounting
 * debug     - sets debug level
 * verbose   - echo to a log file
 *
 *	The functions fatal(), logerr(), and logerr_die() can be used to report
 *	status. The variable errorcode can be set by the user before calling
 *	these functions, and will be the exit value of the program. Its default
 *	value will be 2 (abort status).
 *	fatal() reports a fatal message, and terminates.
 *	logerr() reports a message, appends information indicated by errno
 *	(see perror(2) for details), and then returns.
 *	logerr_die() will call logerr(), and then will exit with errorcode
 *	status.
 *	Both fatal() and logerr_die() call the cleanup() function before exit.
 *
 * DEBUGGING:  a simple minded debugging version can be enabled by
 * compiling with the -DDEBUG option.
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/file.h>
#include <signal.h>

/*
 * default exit status, causes abort
 */
int errorcode = 2;

char *name;		/* name of filter */
/* set from flags */
int debug, verbose, width, length, xwidth, ylength, literal, indent;
char *zopts, *class, *job, *login, *accntname, *host, *accntfile, *format;
char *printer;
int npages;	/* number of pages */
int special;
char filter_stop[] = "\031\001";	/* sent to cause filter to suspend */

main( argc, argv )
	int argc;
	char **argv;
{
	int i;

	getargs( argc, argv );
	/*
	 * Turn off SIGPIPE
	 */
	(void)signal( SIGPIPE, SIG_IGN );
	if( format && *format == 'o' ){
		filter( filter_stop );
	} else {
		filter( (char *)0 );
	}
	doaccnt();
	return(0);
}

/*VARARGS1*/
log(msg, a1, a2, a3)
	char *msg;
{
	(void)fprintf(stderr, "%s: ", name);
	(void)fprintf(stderr, msg, a1, a2, a3);
	(void)putc('\n', stderr);
	(void)fflush(stderr);
}


/*VARARGS1*/
fatal(msg, a1, a2, a3)
	char *msg;
{
	log(msg, a1, a2, a3);
	cleanup();
	exit(errorcode);
}


/*VARARGS1*/
logerr(msg, a1, a2, a3)
	char *msg;
{
	extern int errno, sys_nerr;
	extern char *sys_errlist[];
	int err = errno;

	(void)fprintf(stderr, "%s: ", name);
	if (msg){
		(void)fprintf(stderr, msg, a1, a2, a3);
		(void)fputs( "- ", stderr);
	}
	if( err < sys_nerr ){
		(void)fputs(sys_errlist[err], stderr);
	} else {
		(void)fprintf(stderr, "Unknown error %d", err);
	}
	(void)putc('\n', stderr);
	(void)fflush(stderr);
}

/*VARARGS1*/
logerr_die(msg, a1, a2, a3)
	char *msg;
{
	logerr(msg, a1, a2, a3);
	cleanup();
	exit(errorcode);
}

/*
 *	doaccnt()
 *	writes the accounting information to the accounting file
 *  This has the format: user host printer pages format date
 */
doaccnt()
{
	time_t t, time();
	char *ctime();
	FILE *f;

	t = time((time_t *)0);
	if(accntfile && access(accntfile, W_OK) >= 0 &&
	    (f = fopen(accntfile, "a" )) != NULL) {
		fprintf(f,"%s\t%s\t%s\t%7d\t%s\t%s",
			login? login: "NULL", 
			host? host: "NULL", 
			printer? printer: "NULL", 
			npages,
			format? format: "NULL", 
			ctime(&t));
		(void)fclose(f);
	}
}

getargs(argc, argv)
	int argc;
	char **argv;
{
	int i;		/* argument index */
	char *arg;	/* argument */
	int flag;	/* flag */

	name = argv[0];
	for( i = 1; i < argc; ++i ){
		arg = argv[i];
		if( *arg == '-' ){ /* arg will be string */
				setvar( arg[1], &arg[2] );
		} else {
			/* must be accounting file */
			accntfile = arg;
		}
	}
	if( verbose || debug ){
		for( i = 0; i < argc; ++i ){
			fprintf(stderr, "%s ", argv[i] );
		}
		fprintf( stderr, "\n" );
		fflush(stderr);
	}
	if( debug ){
		fprintf(stderr,"login '%s'\n", login? login : "null" );
		fprintf(stderr,"host '%s'\n", host? host : "null" );
		fprintf(stderr,"class '%s'\n", class? class : "null" );
		fprintf(stderr,"format '%s'\n", format? format : "null" );
		fprintf(stderr,"job '%s'\n", job? job : "null" );
		fprintf(stderr,"printer '%s'\n", printer? printer : "null" );
		fprintf(stderr,"accntname '%s'\n", accntname? accntname : "null" );
		fprintf(stderr,"zopts '%s'\n", zopts? zopts : "null" );
		fprintf(stderr,"literal, %d\n", literal);
		fprintf(stderr,"indent, %d\n", indent);
		fprintf(stderr,"length, %d\n", length);
		fprintf(stderr,"width, %d\n", width);
		fprintf(stderr,"xwidth, %d\n", xwidth);
		fprintf(stderr,"ylength, %d\n", ylength);
		fprintf(stderr,"accntfile '%s'\n", accntfile? accntfile : "null" );
		for( i = 0; i < argc; ++i ){
			fprintf(stderr, "%s ", argv[i] );
		}
		fprintf( stderr, "\n" );
		fflush(stderr);
		fflush(stderr);
	}
}
			
#define INTV 0
#define STRV 1
#define FLGV 2
struct parm {
	int flag;
	char **var;
	int kind;
} Parmlist[] = {
{'C', &class, STRV },
{'D', (char **)&debug, INTV },
{'F', &format, STRV },
{'J', &job, STRV },
{'P', &printer, STRV },
{'R', &accntname, STRV },
{'Z', &zopts, STRV },
{'c', (char **)&literal, FLGV },
{'h', &host, STRV },
{'i', (char **)&indent, INTV },
{'l', (char **)&length, INTV },
{'n', &login, STRV },
{'s', (char **)&special, INTV },
{'v', (char **)&verbose, INTV },
{'w', (char **)&width, INTV },
{'x', (char **)&xwidth, INTV },
{'y', (char **)&ylength, INTV } };

int Parmlen = sizeof(Parmlist)/sizeof(struct parm);

/*
 * setvar( int flag, char *arg )
 * 1. look in table and find entry
 * 2. if STRV, then set 
 * 3. if INTV, then convert and set
 * 4. if FLGV, then set to 1
 */
setvar( flag, arg )
	int flag;
	char *arg;
{
	int u, l, i, c;	/* upper, lower, i */

	l = 0; u = Parmlen;
	while( l <= u ){
		i = (u+l)/2;
		c = flag - Parmlist[i].flag;
		if( 0 == c ){
			/* printf( "found parm %c, %d\n", flag, i ); */
			switch( Parmlist[i].kind ){
			case STRV: *Parmlist[i].var = arg; break;
			case INTV: *(int *)Parmlist[i].var = atoi(arg); break;
			case FLGV: *(int *)Parmlist[i].var = 1; break;
			}
			return;
		} else if( c < 0 ){
			/* fprintf(stderr, "down parm %c, %d\n", flag, i ); */
			u = i - 1 ;
		} else {
			/* fprintf(stderr, "up parm %c, %d\n", flag, i ); */
			l = i + 1 ;
		}
	}
	/* fprintf(stderr, "did not find parm %c, %d\n", flag, i ); */
	return;
}

/*
 * suspend():  suspends the output filter, waits for a signal
 */
suspend()
{
	if(debug)fprintf(stderr,"suspending\n");
	fflush(stderr);
	kill(getpid(), SIGSTOP);
	if(debug)fprintf(stderr,"awake\n");
	fflush(stderr);
}
#ifdef DEBUG
/******************************************
 * prototype filter() and cleanup() functions;
 * filter will scan the input looking for the suspend string
 * if any.
 ******************************************/
cleanup() {}

filter(stop)
	char *stop;
{
	int c;
	int state, i;
	int lines = 0;

	/*
	 * do whatever initializations are needed
	 */
	/* fprintf(stderr, "filter ('%s')\n", stop ? stop : "NULL" ); */
	/*
	 * now scan the input string, looking for the stop string
	 */
	state = 0;
	npages = 1;

	while( (c = getchar()) != EOF ){
		if( c == '\n' ){
			++lines;
			if( lines > length ){
				lines -= length;
				++npages;
			}
		}
		if( stop || state ){
			if( c == stop[state] ){
				++state;
				if( stop[state] == 0 ){
					state = 0;
					if( fflush(stdout) ){
						logerr_die( "fflush returned error" );
					}
					suspend();
				}
			} else if( state ){
				for( i = 0; i < state; ++i ){
					dochar( stop[i] );
				}
				state = 0;
				dochar( c );
			} else {
				dochar( c );
			}
		} else {
			dochar( c );
		}
	}
	if( ferror( stdin ) ){
		logerr_die( "read error on stdin");
	}
	for( i = 0; i < state; ++i ){
		dochar( stop[i] );
	}
	if( lines > 0 ){
		++npages;
	}
	if( fflush(stdout) ){
		logerr_die( "fflush returned error" );
	}
}

dochar(c)
	int c;
{
	putchar( c );
}
#endif DEBUG
