/*
 * COMPAT: a selected set of parameters are passed to the specified file
 * in order to be compatible.  This filter is called with the regular
 * parameters, but will only pass the specified subset.
 * Compat is called with:
 * ..../compat /.../filter [usual options]
 *  OF: filter      -wwidth -llength
 *  IF: filter [-c] -wwidth -llength -iindent -n login -h host accounting_file
 *  ?F: filter      -xwidth -ylength          -n login -h host accounting_file
 */

#include <stdio.h>
extern errno;
char *width, *length, *xwidth, *ylength, *indent, *login, *host, *af, *cflag;
char *debug;
int format;
char *file;
char *newvec[20];

main( argc, argv )
	int argc;
	char **argv;
{
	int i;
	char *arg;

	newvec[0] = argv[1];
	for( i = 2; i < argc; ++i ){
		arg = argv[i];
		if( arg[0] == '-' ){
			switch( arg[1] ){
			case 'w': width = arg; break;
			case 'l': length = arg; break;
			case 'x': xwidth = arg; break;
			case 'y': ylength = arg; break;
			case 'i': indent = arg; break;
			case 'c': cflag = arg; break;
			case 'F': format = arg[2]; break;
			case 'h': host = arg+2; break;
			case 'n': login = arg+2; break;
			case 'D': debug = arg+2; break;
			}
		} else {
			af = arg;
		}
	}
	switch( format ){
	/*
	 *  OF: filter      -wwidth -llength
	 */
	case 'o':
		if( width == 0 || length == 0 ){
			fprintf( stderr, "%s: OF- missing one of -w, -l\n", argv[0] );
			exit( 2 );
		}
		i = 1;
		newvec[i++] = width;
		newvec[i++] = length;
		break;
	/*
	 *  IF: filter [-c] -wwidth -llength -iindent -n login -h host af
	 */
	case 'i':
		if( width == 0 || length == 0
			|| login == 0 || host == 0 ){
			fprintf(stderr,"%s: IF- missing one of -w, -l, -n, -h\n",argv[0]);
			exit( 2 );
		}
		if( indent == 0 ){
			indent = "-i0";
		}
		i = 1;
		if( cflag ){
			newvec[i++] = cflag;
		}
		newvec[i++] = width;
		newvec[i++] = length;
		newvec[i++] = indent;
		newvec[i++] = "-n";
		newvec[i++] = login;
		newvec[i++] = "-h";
		newvec[i++] = host;
		newvec[i++] = af;
		break;
	/*
	 *  ?F: filter      -xwidth -ylength          -n login -h host af
	 */
	default:
		if( xwidth == 0 || ylength == 0
			|| login == 0 || host == 0 ){
			fprintf(stderr,"%s: %cF- missing one of -x, -y, -n, -h\n", argv[0],
				format);
			exit( 2 );
		}
		i = 1;
		newvec[i++] = xwidth;
		newvec[i++] = ylength;
		newvec[i++] = "-n";
		newvec[i++] = login;
		newvec[i++] = "-h";
		newvec[i++] = host;
		newvec[i++] = af;
		break;
	}
	if( debug ){
		for(i = 0; newvec[i]; ++i ){
			fprintf(stderr, "%s ", newvec[i] );
		}
		putc( '\n', stderr );
		fflush(stderr);
	}
	execv( newvec[0], newvec );
	i = errno;
	fprintf( stderr, "%s: execv failed (errno %d)", argv[0], errno);
	errno = i;
	perror( " " );
}
