.bp
.LG
.NH 1
Recently-added Functionality
.SM
.PP
The following is some of the useful features that have been added to
PLP in recent versions, but which don't really fit into the current
organisation of this manual.
.NH 2
Organization of Printcap Information
.PP
If you are working in an environment with a large number of
different hosts and different printers, PLP provides several mechanisms
to aid printcap-file administration.
.PP
.NH 3
Method 1 \- using Hesiod or NIS
.PP
PLP supports the use of Hesiod or NIS databases to hold the printcap
information. See the supplementary document,
.IR EUCS-extensions.ps ,
in the PLP doc subdirectory for details.
.NH 3
Method 2 \- using hostname-qualification on the server's printcap entry
.PP
When performing printcap lookups, PLP will check for a printer called
.I printername/hostname
before checking for
.I printername .
With this setup, it is possible that only one printcap file is needed
for your entire network. Here's an example:
.DS
.DT
.ta 12m +4n +4n
.L
.SM
#
# HP4Mplus printer, PLP client
#
hp|laser|ps|postscript|hp4m-ps:cm=HP LaserJet 4Mplus, postscript:\e
	:sd=/var/spool/print/hp-ps:lf=/share/logs/lpd/hp4m/ps:\e
	:rp=hp4m-ps:rm=class.iona.ie:
#
# HP4Mplus printer, PLP server
#
hp/class|laser/class|ps/class|postscript/class|hp4m-ps/class:\e
	:cm=HP LaserJet 4Mplus, postscript:\e
	:sd=/var/spool/print/hp-ps:lf=/share/logs/lpd/hp4m/ps:\e
	:lp=| tcp-lp exception 9100:rs:pl#66:pw#80:sh:rw:mx#0:
.DE
.PP
.NH 3
Method 3 \- using the plp.conf ``printcap-path'' directive
.PP
The plp.conf file supports a path-based lookup mechanism,
where you can qualify elements of the path by the machine's hostname.
Each file will be checked, in order, and the first entry with
the correct printer name will be used.
.DS
.DT
.L
.SM
printcap-path	/etc/printcap:/var/spool/lpd/printcap.%h:/var/spool/lpd/printcap
.R
.DE
.PP
The %h in this line will be expanded into the host's name, allowing
the administrator to use the following printcaps:
.DS
.DT
.L
.SM
#
# /var/spool/lpd/printcap
#
hp|laser|ps|postscript|hp4m-ps:cm=HP LaserJet 4Mplus, postscript:\e
	:sd=/var/spool/print/hp-ps:lf=/share/logs/lpd/hp4m/ps:\e
	:rp=hp4m-ps:rm=class.iona.ie:
.R
.DE
.PP
and
.DS
.DT
.L
.SM
#
# /var/spool/lpd/printcap.class
#
hp|laser|ps|postscript|hp4m-ps:cm=HP LaserJet 4Mplus, postscript:\e
	:sd=/var/spool/print/hp-ps:lf=/share/logs/lpd/hp4m/ps:\e
	:lp=| tcp-lp exception 9100:rs:pl#66:pw#80:sh:rw:mx#0:
.DE
.PP
.NH 3
Method 4 \- using the include directives
.PP
The printcap, printer_perms and plp.conf files all support
inclusion of other files into them, in the same manner as
preprocessors such as
.IR cpp(1) ,
the C compiler's preprocessor. Say, for example, you place
a line consisting of the following into your printcap file:
.DS
.DT
.L
.SM
include /var/spool/lpd/pcaps/hp4m.remote
.R
.DE
.PP
This will cause your printcap file to include the file
.L /var/spool/lpd/pcaps/hp4m.remote .
You can also use relative paths, in which case the
.IR plp.conf's
config-include-path, printcap-include-path and
printer_perms-include-path directives are used to specify
a list of directories to be searched for these files.
See the
.IR plp.conf(5)
manual page for more details.
.NH 3
Method 5 \- using the scripts in the printcap directory
.PP
If you fancy a solution that'll work with old BSD lpds as 
well as PLP ones, you may find the programs in the
.L printcap
directory handy to manage printcap files.
The organization and management is based on the following structure.
.PP
Each printer has a physical location name and a set of aliases.
For our sample printer,
.L printer_loc ,
There is a
.L printer_loc.local
file which contains a printcap entry suitable for the host which has the device
attached,
a
.L printer_loc.remote
file which contains a printcap entry suitable for a host
which can communicate directly to the remote host,
and a 
.L printer_loc.forward
file which contains a printcap entry suitable for a host
which forwards jobs to either a local or remote host.
For example,
here are typical entries for the 3 files.
These files are stored in the directory
.L printcap/devices .
Figure 11.4 is a sample of several of them.
.KF
.TS
center box;
lw(2.5) |  lw(2.5i) .
.L
.SM
dg1_lind23.local	dg1_lind23.remote
_
T{
.nf
dg1_lind23.local|dg1:\e
    :sd=/var/spool/lpd/dg1_lind23:\e
    :lp=/dev/tty09:ty=9600 -even -odd:
T}	T{
.nf
dg1_lind23.local|dg1:\e
    :sd=/var/spool/lpd/dg1_lind23:\e
    :rm=attila:rp=dg1_lind23:
T}
.TE
.TS
center box;
lw(2.5i) .
.L
.SM
dg1_lind23.forward
_
T{
.nf
dg1_lind23.local|dg1:\e
    :sd=/var/spool/lpd/dg1_lind23:\e
    :rm=attila:rp=dg1_lind23:
T}
.TE
.ce
Figure 11.4  Sample Printcap Files
.KE
.PP
Each host will have a file containing the names of the entries in
the printcap file.
The
.L genpc
program will generate a printcap file from the named printer file
by concatenating the printcap information and placing it in a
.L host.printcap
file.
This file can then be copied to the desired destination.
.NH 2
LP Pipes
.PP
If you intend to use PLP to print to devices that are not connected
to a serial line, such as HP LaserJet printers with the JetDirect
ethernet interface board, or printers connected to Annex terminal
servers, you will probably want to use an
.IR "lp-pipe"
process to communicate with the printer.
.PP
LP-pipes are run as root, and are passed the standard set of
filter arguments on the command-line,
except the accounting filename is replaced by the
status filename (if used; see section 3.9 for details).
In addition,
they are passed the arguments specified in the printcap entry,
and this is where you should include any device-specific parameters.
If you intend to use an LP-pipe, the
.B cl (close
output device between jobs) printcap parameter may prove useful.
See section 6.2 for more details on this.
.PP
The LP-pipe is passed the status filename on the command-line
so it can insert its own progress messages into it, which will
then be displayed to the user via
.IR lpq .
.PP
You may want to use the errors-file functionality with LP-pipes,
in order to communicate device-specific errors back to the
user. This functionality allows you to put an error message into
a file in the spool directory, typically called
.IR errors (although
this can be changed using the
.IR plp.conf
directive
.L errors-file ),
and when an error mail is sent, the contents of this file will
be appended.
.PP
Several sample LP-pipe programs are included with the PLP distribution,
in the
.L src/lp-pipes
subdirectory. See the file
.L doc/README.lp-pipes
for details.
.NH 2
Using the Minfree and Limits Printcap Parameters
.PP
Minfree is a method of stopping the spool directory from filling
up the entire filesystem; if an incoming file would push the
free space on the spool directory's filesystem below this value,
it is refused.
.PP
Limits is similar to the
.B mx
printcap parameter; it is used to specify a maximum job size
for that queue. However, instead of rejecting the print job
straight away, it will accept the job, but will not print it.
This is useful for multiple-device queues; one device queue
could have a low limit value, and would print the smaller
jobs, and another device queue would share the same spool
directory and have a higher limit value, and print the
larger jobs that the first queue skips.
.PP
Both of these fields have dual values; if they are numeric,
they specify the actual value in 1 Kbyte blocks. However, if
their first character is non-numeric, they are treated
as a filename to be opened, from which the desired value
is to be read from.
