.ig
$Header: 10.t,v 1.1 88/05/21 18:39:51 papowell Locked $
$log$
..
.LG
.NH 1
Diagnostics and Troubleshooting
.SM
.PP
The diagnostic messages issued by the PLP software
are verbose to the point of being obnoxious.
Usually there is enough information available to determine the exact cause
of problems.
However,
there are times when a bit of explanation does help, and if you
unsure of the cause of a problem, you should try enabling
the debugging messages to see if the cause becomes any clearer.
.PP
In order to get detailed diagnostic information from any of the
PLP software,
you can enable diagnostic messages using the
.B -D
option.
PLP supports multiple debug settings for different
.I facilities ,
or parts of the PLP functionality.
At the moment, there are the following facilities:
.PP
.SH
pcap - lookups on the printcap file or files
.SH
perms - lookups on the permissions file or files
.SH
remote - the remote-printer transfer mechanism
.SH
local - the local-printer code; stty, device locking, etc.
.SH
conf - the plp.conf reading and filename expansions
.PP
You can also set a general debug setting, which will
set debug modes for all the facilities you don't
explicitly specify, as well as the miscellaneous 
functionality that doesn't fall into one of
the above categories.
.PP
The argument to the -D option is used as follows:
to set a debug level for a particular facility,
use
.B "-D facility=level."
To set the general debug level, use
.B "-D level."
You can also combine these by separating them with
commas, for example
.B "-D pcap=6,4"
would set a general level of 4 and a level of 6 for
the printcap code.
.PP
The debug levels are as follows:
Level 0 is the normal setting (no diagnostic output),
level 3 is chatty,
level 5 is pretty verbose,
and level 9 is absolutely everything.
.NH 2
LPD
.PP
When lpd is started,
it will try and open a log file.
If it cannot,
it will log to /dev/null.
However,
important errors are logged using the
.IR syslog (8)
facility.
You can also specify a log file using the
.B "-L filename"
option to lpd;
.B "-L -"
will cause it to log error messages to standard output.
.PP
Each spool queue has an associated log file as well,
as does each server for a spool queue.
Most of the PLP software will also use
.IR syslog (8)
for important messages,
or log them to
.L /dev/console
if syslog is not available.
.NH 2
LPR
.SH
lpr: \fIprinter\fP\|: unknown printer
.IP
The
.I printer
was not found in the
.I printcap
database.
Usually this is a typing mistake;
however,
it may indicate a missing or incorrect entry in the printcap file.
.SH
lpr: \fIprinter\fP\|: jobs queued, but cannot start server.
.IP
The connection to 
.I lpd
on the local machine failed. 
This usually means the lpd process started at
boot time has died or is hung.
Use the
.L "lpc lpd"
command to check that the
.I lpd
process is running.
If it appears to be absent,
start a new lpd process using the following command.
.DS
.L
.SM
% /usr/local/bin/lpd
.DE
.NH 2
LPQ
.SH
waiting for \fIprinter\fP to become ready (trying since ????)
.IP
The printer device could not be opened by the server. 
This can happen for a number of reasons,
the most common being that the printer is turned off-line.
This message can also be generated if the printer is out
of paper, the paper is jammed, etc.
The actual reason is dependent on the meaning
of error codes returned by the system device driver. 
Not all printers supply sufficient information 
to distinguish when a printer is off-line or having
trouble (e.g. a printer connected through a serial line). 
Another possible cause of this message is
that some other process, such as an output filter,
has an exclusive open on the device.  Your only recourse
here is to kill off the offending program(s) and
restart the printer with
.IR lpc .
.SH
connecting to <host> (trying since ????)
.IP
The server is trying to connect to the remote site and nothing has happened.
The first indication is that the network is dead,
or the host you are trying to reach is down.
If the remote host is up,
.I lpd
on the remote machine is probably dead or
hung and should be restarted.
.SH
warning: no server present
.IP
There are entries in the spool queue,
but no server exists.
This normally occurs when the server has not started yet; if
this message persists and the jobs are not unspooled, the server
may actually have unexpectedly died.
The error log file for the spool queue should be checked for a
diagnostic from the deceased process.
Use the lpc restart command to start a server.
