.ig
$Header: 08.t,v 1.1 88/05/21 18:39:46 papowell Locked $
$log$
..
.bp
.LG
.NH 1
Using an NFS Spool Directory
.SM
.PP
In an NFS environment,
a common or shared spool directory can be used to avoid needless
copying or duplicate rules.
The
.I lpr
program places jobs in the shared spooling directory
and then requests the
.I lpd
daemon on the appropriate remote machine to start unspooling actions.
The
.B nw
(networked file system)
flag and
.B rm
(remote machine)
are used to indicate this type of file system organization.
.PP
In this environment,
only machines which have printers attached or are acting as
forwarding systems to other machines need to have an
.I lpd
daemon running.
.PP

The convention of keeping the printcap and printer_perms files in the
.L /etc
directory is easy to use in a single host or loosely
coupled multiple processor environment,
it can be difficult to manage and apply in a network based
around a distributed file system such as NFS.
The PLP software allows the
.L printcap and
.L printer_perms
files to be kept in the
.L /var/spool/lpd
directory, qualified by hostname; with an NFS-mounted
.L /var/spool/lpd
directory, this will greatly simply administration.
This can be accomplished using the
.I plp.conf
file's
.L printcap-path
and
.L printer_perms-path
directives, as follows.
.DS
.DT
.ta 12m +4n +4n
.L
.SM
printcap-path		/etc/printcap:/var/spool/lpd/printcap.%h:/var/spool/lpd/printcap
printer_perms-path	/etc/pperms:/var/spool/lpd/pperms.%h:/var/spool/lpd/pperms
.DE
Each file will be checked for a matching printcap, and the first matching
entry found will be used, so you can put only the local entries in
.L /var/plp/printcap.hostname ,
and a general-case
.L rm=hostname,rp=port
entry in
.L /var/plp/printcap .
If you wish to simplify things even more, use a qualified printer-name in
the local printcap entry, so it is specified as
.B "hp4m-ps/hostname"
and then specify the general-case entry in the normal way. This allows
you to use one printcap file for the entire network.
.PP

See the manual page
.I plp.conf(5)
and the sample configuration file ``plp.conf.nfs'' in the examples subdirectory
for more details.

.PP
One of the problems with the current implementation of the NFS
distributed file system is file locking across file systems.
The current implemenation of PLP uses either the
.I fcntl,
.I lockf
or
.I flock
facility,
selected at compilation time.
Only
.I fcntl
and
.I lockf
will perform correctly when locking a file on an NFS file system.
Most implementations of NFS do not support atomic exclusive file-creation,
which is very important for PLP; PLP, however, does support this,
using a really grotesque hack.
.PP
A warning message will be logged if
an NFS spool directory is used in conjunction with
.I flock
file locking.
