.ig
$Header: 01.t,v 1.1 88/05/21 18:39:31 papowell Locked $
$log$
..
.LG
.NH 1
Overview
.SM
.PP
The Public Line Printer Spooler (PLP) software is a
reverse engineered version of the Berkeley Line Printer Spooler (LPD).
During the implementation,
there was no resort to any of the Berkeley LPD source,
other than for tables that are used to print big letter banners\**.
.FS
The author has seen these appear in several public domain games programs,
and has recollections of running card decks which produced
suspiciously similar output.
.FE
Due to experience with the Berkeley software,
some LPD routines and functionality may be duplicated,
but in general the implementation and structure of the PLP software is
radically different.
.PP
The Public Line Printer Spooler supports:
.IP 1). 3
More than one printer per spooling queue.
.IP 2). 3
Multiple prioritized spooling queues.
.IP 3). 3
Both local and remote printers.
.IP 4). 3
Printers attached via serial lines,
which can have line characteristics such as baud rate,
parity,
etc., specified.
.IP 5). 3
Devices such as an Imagen laser printer which may
require a special communications protocol for printing.
.IP 6). 3
Operation in a shared file system environment (such as NFS).
.IP 7). 3
Restriction of use by a printer permissions data base.
In addition to a per-host database,
each individual spool queue may have a supplementary database.
.PP
The major components of line printer system are the
following files and commands in Table 1.1.
.TS
center box;
l | l | l.
Name	Type	Purpose
_
/etc/plp.conf	file	PLP configuration file
/etc/printcap	file	printer configuration and capability data base
/etc/printer_perms	file	printer permissions data base
/var/spool/lpd/log.<host>	file	daemon log file
/var/spool/lpd/lock.<host>	file	daemon lock
/usr/local/bin/lpd	daemon	line printer daemon
/usr/local/bin/lpr	command	enter a job in a printer queue
/usr/local/bin/lpq	command	examine queues
/usr/local/bin/lprm	command	delete jobs from a queue
/usr/local/bin/lpc	command	administer printers and spooling queues
printer,tcp	port	inet service port on which lpd listens
.TE
.ce
Table 1.1 Major PLP Components
.PP

The locations of most of these components can be changed using the
.I plp.conf
configuration file, which usually lives in /etc, but whose location is
determined at compile-time. See the manual page
.I plp.conf(5)
for more details.
.PP

The
.L printcap
file
is a master data base describing
characteristics of line printers either directly attached to the host
or accessible across a network. The format of the printcap database is based on the
.IR termcap (5)
format.
.PP

The
.L printer_perms
or printer permissions file is used by PLP to allow or deny access to operations,
queues, and services, based on user, group, and remote machine, and supports
shell-like wildcard matching on all its fields.
The printer permissions file is similar in purpose to the
.I hosts.lpd
file that is used by the BSD lpd, but has significantly extended functionality.
.PP

PLP also includes support for printcap and printer_perms lookups
using the NIS and Hesiod network database protocols. See the supplementary
document,
.I "Cross-Domain printing using Hesiod with PLP" ,
for more details.
.PP

The
.L log and
.L lock
files have the form:
.L /var/spool/lpd/<file>.<host> ,
where
.L <host>
is the fully-qualified form of the host name.
This allows a single spool directory to be made available via NFS to
all the systems using PLP.
All files in the spool directory are created using the
.L daemon
user and group ID,
avoiding problems with NFS systems and root userids.
.PP

The
.L lpd
program is a
.I daemon
or server program that carries out actions as requested by other programs.
The
.L lpr
program creates print jobs in the appropriate spool queue,
and then requests the
.L lpd
daemon to perform unspooling actions.
The
.L lpq
program is used to print the status of local and remote spool queues.
The
.L lprm
program is used to remove jobs from spool queues,
and the
.L lpc
program is used to control spooling and unspooling activities.
.PP

Communication between the
.L lpd
daemon and the utility programs is done using the Internet TCP/IP
communications support provided by most UNIX systems.
Each host has an
.L lpd
daemon which listens on a well known port of the host,
and carries out requested activities.
.PP

The remainder of this document provides details of the structure and
implementation of the above facilities and programs.
Section 2 describes the functionality of the
.L lpd
daemon and  the 
.L "lpr" ,
.L "lpq" ,
.L "lprm" ,
and
.L "lpc"
programs.
Section 3 describes the structure of the spool directory associated
with each spool queue,
and the security precautions taken to ensure the integrity of the
the spool directory and print jobs.
Section 4 is a description of the
.I printcap
data base,
and how the information in the database
is used by PLP to perform spooling operations.
Section 5 is a description of the inter-host file transfer protocol used
by PLP.
Section 6 is a description of the unspooling operations carried out by the
.I lpd
program,
and how they are controlled by the printcap information.
Section 7 details how filter programs are invoked by the spool server
processes and how they are specified in the printcap.
Section 8 describes how PLP can be used in a networked file system
environment.
Section 9 outlines how the
.I lpc
program is used to control spooling operations.
Section 10 is a discussion of the diagnostic information supplied by
the PLP programs.
Section 11 documents ways of testing PLP before a full installation.
Section 12 documents some of the features recently introduced to
PLP (since version 3.4.0) that don't really fit anywhere else
in the documentation.
