#include <stdio.h>
#include "file2.h"
#include "internal.h"
#include <trace.h>

/***************************************************************************
 *
 * Function:   puts
 *
 * Description:
 *    Write a string with a terminating newnline to the stdout file.
 *
 * Entry:
 *    pszString - pointer to the input string to be written.
 *
 * Returns:
 *    0 to indicate success
 *   -1 to indicate some error or EOF condition.
 */

int puts (const char *pszString)
    {
    int          fBuffing;
    unsigned int unLength;
    unsigned int unDone;
    FUNC_ENTRY ("puts");
/*
 *  Correct the buffering mode and write the string
 */
    unLength = strlen (pszString);
    fBuffing = _stbuf (stdout);
    unDone   = (unsigned int) fwrite (pszString, 1, unLength, stdout);
    _ftbuf (fBuffing, stdout);
/*
 *  If the entire string was written then append a newline character
 */
    if (unDone == unLength)
        {
        putc ('\n', stdout);
        }
/*
 *  Return the proper status to the caller.
 */
    FUNC_EXIT ("puts");
    return (unDone == unLength ? 0 : -1);
    }
