/*
 * This contains references to all the userfs protocol operations this
 * library supports.  For each operation there is a macro which says
 * whether it is a filesystem, inode or file operation, and whether it
 * has arguments or return values.
 *
 * This is used for automatically generating prototypes in class
 * definitions, and implementations of stub versions of these functions.
 *
 * For inode and file operations it also should really have macros for
 * extracting the handle from the arguments.
 *
 * Copyright (C) 1995 Jeremy Fitzhardinge <jeremy@sw.oz.au>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#if !defined(DO) || !defined(DOa) || !defined(DOr) || !defined(DOar)
#error "Need DOxx macros defined"
#endif

#if !defined(opSUPER) && !defined(opINODE) && !defined(opFILE)
#define opSUPER
#define opINODE
#define opFILE
#endif

/* Super operations */
#ifdef opSUPER
#undef opSUPER
	
DOr(mount);
DO(umount);
DOr(statfs);

#endif /* opSUPER */

/* Inode operations */
#ifdef opINODE
#undef opINODE
	
DOar(create);
DOar(lookup);
DOa(link);
DOa(unlink);
DOa(symlink);
DOa(rename);
DOar(readlink);
DOar(followlink);
DOa(permission);
DOa(iwrite);
DOar(iread);
DOa(iput);
DOa(notify_change);
DOa(truncate);

#endif /* opINODE */

/* File operations */
#ifdef opFILE
#undef opFILE
	
DOar(read);
DOar(write);
DOar(readdir);
DOar(multireaddir);
DOar(open);
DOa(close);

#endif /* opFILE */

#undef DO
#undef DOa
#undef DOr
#undef DOar


