/*
 * Simple IO functions
 *
 * These are just like read() and write(), except they will try
 * to process all the requested data, unless there's an error or
 * EOF.  They also cope with EINTR.
 * 
 * Copyright (C) 1995 Jeremy Fitzhardinge <jeremy@sw.oz.au>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <sys/types.h>

#include "io.h"

size_t
fullread(int from, unsigned char *buf, size_t sz)
{
	size_t	rd = 0;
	size_t	ret;
	
	while(sz > 0)
	{
		ret = read(from, buf, sz);

		if (ret == (size_t)-1)
		{
			if (errno == EINTR)
				continue;

			return -1;
		}

		if (ret == 0)
			break;
				
		sz -= ret;
		buf += ret;
		rd += ret;
	}

	return rd;
}

size_t
fullwrite(int tofd, const unsigned char *buf, size_t sz)
{
	size_t	wr = 0;
	size_t	ret;
	
	while(sz > 0)
	{
		ret = write(tofd, buf, sz);

		if (ret == (size_t)-1)
		{
			if (errno == EINTR)
				continue;
			return -1;
		}

		if (ret == 0)
		{
			fprintf(stderr, "fullwrite wrote 0 bytes\n");
			break;
		}

		sz -= ret;
		buf += ret;
		wr += ret;
	}

	return wr;
}
